#include "mbed.h"

#include "CarreraDigitalControlUnit.h"

int main() {
    // set digital pin 2 as input - make sure it does not deliver more
    // than 5V or 3.3V, depending on platform!
    CarreraDigitalControlUnit cu(D2);
    
    // set digital pins 3 to 7 as outputs (connected to LEDs)
    DigitalOut led1(D3);
    DigitalOut led2(D4);
    DigitalOut led3(D5);
    DigitalOut led4(D6);
    DigitalOut led5(D7);

    while (true) {    
        uint8_t prog[3];
        int data = cu.read();
        if (cu.split_programming_word(data, prog)) {
            // prog = { command, value, address }
            if (prog[0] == 16 && prog[2] == 7) {
                led1 = prog[1] >= 1;
                led2 = prog[1] >= 2;
                led3 = prog[1] >= 3;
                led4 = prog[1] >= 4;
                led5 = prog[1] >= 5;
            }
        }
    }
}
