#include "mbed.h"

#include "CarreraDigitalControlUnit.h"

int main() {
    // set digital pin 2 as input - make sure it does not deliver more
    // than 5V or 3.3V, depending on platform!
    CarreraDigitalControlUnit cu(D2);
    mbed::Serial pc(USBTX, USBRX);
    uint8_t lap = 0;

    cu.start();

    while (true) {
        uint8_t prog[3];
        int data = cu.read();
        if (cu.split_programming_word(data, prog)) {
            // prog = { command, value, address }
            const uint8_t command = prog[0];
            const uint8_t value = prog[1];
            const uint8_t address = prog[2];
    
            switch (command) {
            case 6:
                if (value == 9 && address == 0) {
                    pc.puts("Start new race\r\n");
                    lap = 0;
                } else {
                    pc.printf("#%d: Position %d\r\n", address, value);
                }
                break;
            case 8:
                pc.printf("#%d: New fastest lap\r\n", address);
                break;
            case 9:
                pc.printf("#%d: Lap finished\r\n", address);
                break;
            case 11:
                pc.printf("#%d: False start\r\n", address);
                break;
            case 17:
                lap = (lap & 0x0f) | (value << 4);
                break;
            case 18:
                lap = (lap & 0xf0) | value;
                pc.printf("Lap %d\r\n", lap);
                break;
            }
        }
    }    
}
