#include "mbed.h"
#include "FreeRTOS.h"
#include "task.h"
#include "LM75B.h"
#include "MMA7660.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
LM75B sensor(p28,p27);
MMA7660 mma(p28,p27);

void vtemperature(void *pvParameters);
void vshock(void *pvParameters);

int main() {
    
    portBASE_TYPE task1rc;
    portBASE_TYPE task2rc;
    
    // Sensor connection check
    if (sensor.open()){
        printf("LM75B temperature sensor detected.\n");
    }
    else {
        printf("LM75B sensor not detected!\n");
        return 1;
    }
    
    if (mma.testConnection()){
        printf("MMA7660 accelerometer sensor detected.\n");
    }
    else {
        printf("MMA7660 sensor not detected!\n");
        return 1;
    }
    printf("All sensors acounted for. Proceeding with program.\n");
    
    // Task 1 will read and print temperature data
    task1rc = xTaskCreate(vtemperature, "HELLO", 255, (void*)"TASK1", configMAX_PRIORITIES-2, NULL);
    
    // Task 2 will read accelerometer data
    task2rc = xTaskCreate(vshock, "BYE", 255, (void*)"TASK2", configMAX_PRIORITIES-1, NULL);
    
    vTaskStartScheduler();
    
    for (;;){
        /*If the tasks fail to initialize/run properly, led3 and led4 will
        toggle on/off to indicate the failure. */
        led3 = 1;
        led4 = 1;
        wait(0.5);
        led3 = 0;
        led4 = 0;
        wait(0.5);
    };
    
}

void vtemperature(void *pvParameters)
{
    char *ptr = 0;
    float tdata = 0.0;
    ptr = (char *)pvParameters;
    int time = 0;
    
    for(;;)
    {
        tdata = (float)sensor.temp();
        printf("sample %i: %.3f c\n", time, tdata);
        led1 = !led1;
        time++;
        vTaskDelay(300);
    }
}

void vshock(void *pvParameters)
{
    char *ptr = 0;
    float accel_z = 0.0;
    ptr = (char *)pvParameters;
    int time = 0;
    
    for(;;)
    {
        accel_z = mma.z();
        printf("sample %i: %.3f g\n", time, accel_z);
        led2 = !led2;
        time++;       
        vTaskDelay(300);
    }
}