/*
 * WS2812 tape led IC
 */
#include "mbed.h"
#include "LEDStrip.h"

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

extern "C"
void HardFault_Handler() {
    printf("Hard Fault!\r\n");
    exit(-1);
}

int main() {
    int j, k = 0;

    pc.baud(115200);
    tapeInit(0, 16);
    led1 = 1;

    pc.printf("led\r\n");

    for (;;) {
        for (long int i = 0; i < 256; i++) {
            int val = i;
            for(int j=0;j<16;j++){
              tapeSet(j, val);
            }
            tapeSend();
            wait_ms(2);
        }
    }
    for (;;) {
        for (long int i = 0; i < 256; i++) {
            int val = (i << 8)|(255-i);
            for(int j=0;j<16;j++){
              tapeSet(j, val);
            }
            tapeSend();
            wait_ms(2);
        }
        for (long int i = 0; i < 256; i++) {
            int val = (i << 16)|((255-i)<<8);
            for(int j=0;j<16;j++){
              tapeSet(j, val);
            }
            tapeSend();
            wait_ms(2);
        }
        for (long int i = 0; i < 256; i++) {
            int val = ((255-i)<<16)|i;
            for(int j=0;j<16;j++){
              tapeSet(j, val);
            }
            tapeSend();
            wait_ms(2);
        }
        //for (i = 0; i < 160; i ++) {
        //    tapeSet(i, 0);
        //}
        //tapeSend();
    }
}
