#include "mbed.h"

#include "mrubyc/hal/hal.h"
#include "mrubyc/mrubyc.h"

DigitalIn mybutton(USER_BUTTON);
DigitalOut myled(LED1);
RawSerial mysci(USBTX, USBRX);

extern const uint8_t sample1[];
extern const uint8_t sample2[];

int hal_write(int fd, const void *buf, size_t nbytes)
{
    return mysci.write((const uint8_t *)buf, (int)nbytes, NULL, SERIAL_EVENT_TX_COMPLETE);
}

int hal_flush(int fd)
{
    char char1 = 0;
    while (mysci.readable()) 
    { 
        char1 = mysci.getc();
    }
    return 0;
}

void hal_delay(mrb_vm *vm, mrb_value *v)
{
    wait_ms((int)GET_INT_ARG(0));
}

void hal_led(mrb_vm *vm, mrb_value *v)
{
    myled = (int)GET_INT_ARG(0);
}

void hal_button(mrb_vm *vm, mrb_value *v)
{
    int sw = mybutton;
    SET_INT_RETURN(sw);
}

int main() {
    mysci.baud(115200);                     // 115Kbps
    mysci.format(8, Serial::None, 1);       // 8bt, none parity, stop bit 1
    mrbc_init();
    mrbc_define_method(0, mrbc_class_object, "led1_write", hal_led);
    mrbc_define_method(0, mrbc_class_object, "delay", hal_delay);
    mrbc_define_method(0, mrbc_class_object, "sw1_read", hal_button);
    mrbc_create_task( sample1, 0 );
    mrbc_create_task( sample2, 0 );
    
    mrbc_run();
    
}
 