//seg7_LED.h

/*
      a
     ---
  f |   | b
     -g-
  e |   | c
     ---  .h
      d
*/


#ifndef SEG7_LED
#define SEG7_LED


#define SEG7_LED_1
//#define SEG7_LED_2
//#define SEG7_LED_3
//#define SEG7_LED_4

#include "mbed.h"

class seg7_LED
{
    #ifdef SEG7_LED_1
    private:
        DigitalOut seg1, seg2, seg3, seg4, seg5, seg6, seg7;
    public:
        //a~g:number(1LED)
        seg7_LED(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g);        
    #endif
    
    #ifdef SEG7_LED_2
    private:
        DigitalOut seg1, seg2, seg3, seg4, seg5, seg6, seg7, seg8, seg9;
    public:
        //a~g:number, h~i:common (2LEDs)
        seg7_LED(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, PinName h, PinName i);
    #endif
    
    #ifdef SEG7_LED_3
    private:
        DigitalOut seg1, seg2, seg3, seg4, seg5, seg6, seg7, seg8, seg9, seg10;
    public:
        //a~g:number, h~j:common (3LEDs)
        seg7_LED(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, PinName h, PinName i, PinName j);
    #endif
    
    #ifdef SEG7_LED_4
    private:
        DigitalOut seg1, seg2, seg3, seg4, seg5, seg6, seg7, seg8, seg9, seg10, seg11;
    public:
        //a~g:number, h~k:common (4LEDs)
        seg7_LED(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, PinName h, PinName i, PinName j, PinName k);        
    #endif
    
    public:
        bool disp_num(int num);
};


#endif