/*
 SPFD5408A or ST7781R TFT Library. 
 
 2015 Copyright (c) Bluegrass Digital Inc.
 
 Authors: TJ Forshee (with initializtion code from TFT vendor)

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#ifndef TFT_h
#define TFT_h

#include "mbed.h"

//Basic Colors
#define RED         0xf800
#define GREEN       0x7e00
#define BLUE        0x001f
#define BLACK       0x0000
#define YELLOW      0xffe0
#define WHITE       0xffff

//Other Colors
#define CYAN        0x07ff  
#define BRIGHT_RED  0xf810  
#define GRAY1       0x8410  
#define GRAY2       0x4208  

//TFT resolution 240*320
#define MIN_X   0
#define MIN_Y   0
#define MAX_X   239
#define MAX_Y   319

//========================================
//#define DDR_CS      DDRB
//#define PORT_CS     PORTB
//#define CS_BIT      0x04 // B.2 = D10
// {DDR_CS|=CS_BIT;}
// {PORT_CS|=CS_BIT;}
// {PORT_CS&=~CS_BIT;}

//-----------------------------------------

//#define DDR_RS      DDRB
//#define PORT_RS     PORTB
//#define RS_BIT      0x08 // B.3 = D11
// {DDR_RS|=RS_BIT;}
// {PORT_RS|=RS_BIT;}
// {PORT_RS&=~RS_BIT;}

//-----------------------------------------

//#define DDR_WR      DDRB
//#define PORT_WR     PORTB
//#define WR_BIT      0x10 // B.4 = D12
// {DDR_WR|=WR_BIT;}
// {PORT_WR|=WR_BIT;}
// {PORT_WR&=~WR_BIT;}
// {PORT_WR|=WR_BIT;PORT_WR&=~WR_BIT;}

//-----------------------------------------

//#define DDR_RD      DDRB
//#define PORT_RD     PORTB
//#define RD_BIT      0x20 // B.5 = D13
// {DDR_RD|=RD_BIT;}
// {PORT_RD|=RD_BIT;}
// {PORT_RD&=~RD_BIT;}
// {PORT_RD|=RD_BIT;PORT_RD&=~RD_BIT;}
//========================================

extern unsigned char simpleFont[][8];

class TFT
{
public:

    unsigned int IC_CODE; //Stores Driver IC ID (either SPFD5408A  or ST7781R)

    void init (void);
    void sendCommand(unsigned int index);
    void sendData(unsigned int data);
    void pushData(unsigned char data);
    unsigned char getData(void);
    unsigned int readRegister(unsigned int index);

    unsigned int constrain(unsigned int val2chk, unsigned int lowval, unsigned int highval);
    void setXY(unsigned int poX, unsigned int poY);
    void setPixel(unsigned int poX, unsigned int poY,unsigned int color);
    void drawLine(unsigned int x0,unsigned int y0,unsigned int x1,unsigned int y1,unsigned int color);
    void drawVerticalLine(unsigned int poX, unsigned int poY,unsigned int length,unsigned int color);
    void drawHorizontalLine(unsigned int poX, unsigned int poY,unsigned int length,unsigned int color);
    void drawRectangle(unsigned int poX, unsigned int poY, unsigned int length,unsigned int width,unsigned int color);
    void fillRectangle(unsigned int poX, unsigned int poY, unsigned int length, unsigned int width, unsigned int color);
    void drawCircle(int poX, int poY, int r,unsigned int color);
    void fillCircle(int poX, int poY, int r,unsigned int color);
    void drawChar(unsigned char ascii,unsigned int poX, unsigned int poY,unsigned int size, unsigned int fgcolor);
    void drawString(char *string,unsigned int poX, unsigned int poY,unsigned int size,unsigned int fgcolor);
    unsigned char drawNumber(long long_num,unsigned int poX, unsigned int poY,unsigned int size,unsigned int fgcolor);
    unsigned char drawFloat(float floatNumber,unsigned char decimal,unsigned int poX, unsigned int poY,unsigned int size,unsigned int fgcolor);
    unsigned char drawFloat(float floatNumber,unsigned int poX, unsigned int poY,unsigned int size,unsigned int fgcolor);
    
    void all_pin_input(void);
    void all_pin_output(void);
    void all_pin_low(void);
    void CS_HIGH(void);
    void CS_LOW(void);
    void RS_HIGH(void);
    void RS_LOW(void);
    void WR_HIGH(void);
    void WR_LOW(void);
    void WR_RISING(void);
    void RD_HIGH(void);
    void RD_LOW(void);
    void RD_RISING(void);

    void setOrientation(unsigned int HV);
};

extern TFT Tft;

#endif
