#include "mbed.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "SLCD.h"
#include "TSISensor.h"

#define MMA8451_I2C_ADDRESS (0x1d << 1)
#define MAG3110_I2C_ADDRESS (0x0e << 1)

Serial pc(USBTX, USBRX);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
MAG3110 mag(PTE25, PTE24, MAG3110_I2C_ADDRESS);
AnalogIn lightSensor(PTE22);
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
Timer tt;
SLCD slcd;
TSISensor tsi;

int main() {
        float accel, magma, light, touch;
        int a=0, m=0, l=0, t = 0; 
        tt.reset();
        while (true){
                    tt.start();
                 int time = tt.read_ms();
         //   pc.printf(" time = %d",time);
            if (a == 0){
                 accel = acc.getAccX();
                 a = 10;
                 }
                 a--;
            if (m == 0){
                 magma= mag.readVal(MAG_OUT_X_MSB);
                 m =10;
                 }
                 m--;
            if(l == 0){
                 light = lightSensor.read();
                 l=10;
                 }
                 l--;
            if (t == 0){
                 touch = tsi.readPercentage();
                 t= 10;
                 }
                 t--;
                 
            pc.printf(" a = %f, m = %f,l = %f,t = %f\n", accel, magma, light, touch);
            int time1 = tt.read_ms();
            tt.stop();
            pc.printf("tt= %d\n",(time1-time));
            wait((50.0-(time1-time))/1000.0);
        }
}