#include "mbed.h"
#include <math.h>
#include <cmath>
#include "TSISensor.h"
#include "SLCD.h"
#define LEDON false
#define LEDOFF true
#define NUMBUTS 2   //two buttons
#define LBUT PTC12  //left button // port addresses for buttons
#define RBUT PTC3 //right button
#define ARGUMENTSTATE 0 //Switch case 0
#define ANSWERSTATE 1 //Switch case 1
#define LCDTIME 1.0 //LCD Timer 1 sec
#define TSILIMIT 0.01
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define BUTTONTIME 0.1
#define PROGNAME "KBrat-SSD541-Midterm-Q2b \nCubic Root\n\r"

SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);

Timer LCDTimer; //for reading lcd input state for display
Timer dataTimer; //for reading data input states(from the slider 1-100)
Timer ButtonTimer; //for reading button states
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
float tsidata;
//int displayState;
int displayState = ARGUMENTSTATE;//Make initial state ARGUMENTSTATE

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    dataTimer.start();
    dataTimer.reset();
    LCDTimer.start();
    LCDTimer.reset();  
} 

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

int main(void) {
    int i;
    char lcdData[LCDCHARLEN];
    float lastTouch = 0.0; //intial lastTouch starts at 0.0
    TSISensor tsi;
    float tempTSI;
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    
    initialize_global_vars();

     while (true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 //find buttons
                if(!buttons[i]) { 
                    displayState = i;
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
        }
        
        
        if(LCDTimer.read() > LCDTIME){
            LCDTimer.reset();                               
            switch (displayState){ //start switch case for displayState 
                
                case ARGUMENTSTATE: { // case #0
                    rled = 0.0;//red light on
                    gled = 1.0;//green light off

                    if(dataTimer.read() > DATAINTERVAL){
                        dataTimer.reset();                               
                        tempTSI = tsi.readPercentage();        
                        if (tempTSI > TSILIMIT){
                            tsidata = tempTSI;
                            if (fabs(tsidata - lastTouch)> PRINTDELTA){
                                //int randomNum = rand() % 101 + (-50);
                                //tsidata = tsidata*randomNum;
                                //if(tsidata < 0.0)
                                //pc.printf("Position z%2.1f", fabs(tsidata));
                                pc.printf("Position %2.0f\n\r", tsidata*50); //print to computer tsidata*50 to get a range from 1-50
                                
                            }           
                        }
                        lastTouch=tsidata;
                    }
        
                    sprintf (lcdData,"%2.1f",tsidata*50); //print to lcd screen tsidata*50 to get a range from 1-50
                    LCDMess(lcdData); 
                    
                    /*sprintf (lcdData,"%2.1f",tsidata*50)&
                    sprintf (lcdData,"%2.1f",tsidata*(0-50));
                    if(tsidata < 0.0) sprint (lcdData,"z%2.1f", fabs(tsidata*(0-50));
                    LCDMess(lcdData);*/

                break;
                }
                
                case ANSWERSTATE: {
                    
                    rled = 1.0;//red light off
                    gled = 0.0;//green light on
                    
                    double slid_input, cub_root;
                    slid_input = tsidata*50;
                    if (slid_input > 0){
                    cub_root = cbrt(slid_input);//built-in cubic root function
                    pc.printf ("Cubic root(%2.2f) = %2.2f\n", slid_input, cub_root);
                    sprintf (lcdData,"%2.2f", cub_root);
                    }
                    break;
                }// end switch displaystate
            }                 
            LCDMess(lcdData); 
        } // end LCD timer.read
            
    }// end while(true)
        
}