#include "mbed.h"
#include <math.h>  
#include "SLCD.h"

#define LEDON false
#define LEDOFF true
#define NUMBUTS 2
#define LBUT PTC12  // port addresses for buttons
#define RBUT PTC3
#define STOPPEDSTATE 0
#define TIMINGSTATE  1
#define RESETTINGSTATE 2
#define PRINTDELTA 0.01
#define LCDCHARLEN 10
#define BUTTONTIME 0.2
#define FULLMINUTE 60 //seconds
#define PROGNAME "KBrat-SSD541-HW-9.2"
#define LCDTITLE "STPW"
#define TITLEWAIT 2.0

//#define PRINTDBUG // uncomment if printing to serial port desired

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);

Timer ButtonTimer; // for reading button states
DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
int displayState = STOPPEDSTATE;

void initialize_global_vars(){
    pc.printf(PROGNAME);
    // set up DAQ timer
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset(); 
} 

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}
void showTitle(){
    LCDMess(LCDTITLE);
    wait(TITLEWAIT);
    return;
}
int main(void) {
    int i;
    char lcdData[LCDCHARLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    pc.printf(PROGNAME);
    float secondsCount = 0.0;
    int minutesCount; // for displaying mininuts
    int seconds; //
    int fifthSeconds;
    //bool statetoggle = false; //was in stopped state.
    
    initialize_global_vars();
    showTitle();

     while (true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1
                if(!buttons[i]) { // a button is pressed
                    displayState = i; 
                    
                    
                   /* switch (displayState){  // this keeps things generic
                        case TIMINGSTATE: {              
                         statetoggle = !statetoggle;
                         break;
                        }
                        case RESETTINGSTATE :{
                        break;
                        }
                    }*/   
                }else if(!buttons[0] && !buttons[1]){ 
                        switch (displayState){
                            case RESETTINGSTATE:{
                                /*secondsCount = 0;
                                displayState = TIMINGSTATE;
                        
                                rled = 0.0;
                                gled = 1.0;*/
                        
                                break;
                                }
                        }
                    } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
            
            switch (displayState){
                   
                    case STOPPEDSTATE : { //state 0                  
                        rled = 0.0;
                        gled = 1.0;
                        break;
                    }
                        
                    case TIMINGSTATE : { //state 1    
                        secondsCount = secondsCount + BUTTONTIME;               
                        rled = 1.0;
                        gled = 0.0;
                        
                        break;
                    }
                        
                    case RESETTINGSTATE: {//state 2
                        secondsCount = 0;
                        displayState = TIMINGSTATE;
                        
                        rled = 0.0;
                        gled = 0.0;
                        break;
                        
                    }
                    
                    /*case TIMINGSTATE : { //state 1
                        if(statetoggle){
                            secondsCount = secondsCount + BUTTONTIME; 
                        }        
                        rled = 1.0;
                        gled = 0.0;
                        
                        break;
                        
                    case RESETTINGSTATE: //state 2
                        if (!statetoggle){ 
                            secondsCount = 0;
                            displayState = TIMINGSTATE;
                        }
                        rled = 0.0;
                        gled = 1.0;
                        break;
                        
                    }*/
            }
            
            // Parse the seconds
            seconds = (int)secondsCount; // make seconds "mask"
            fifthSeconds = (int)((secondsCount - (float)seconds) * 10); // the 0.2 seconds
            minutesCount = seconds / FULLMINUTE;
            seconds = seconds % FULLMINUTE;          
            sprintf (lcdData,"%1d.%02d.%1d",minutesCount,seconds,fifthSeconds);  
            LCDMess(lcdData);            
        }// end Button timer
    }
}