#include "mbed.h"
#include "SLCD.h"


#define PROGNAME "KBrat-SSD541-HW-5_2_Part1\n\r"
#define DATATIME 400 // milliseconds
#define LCDLEN 10
#define LIGHTSENSORPORT PTE22



SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);
Timer LEDTimer;

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 


int main() {
    AnalogIn LightSensor(LIGHTSENSORPORT);
    float lightData; 
    char lcdData[LCDLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
   
    int timeToChangeDF = DATATIME;
    LEDTimer.start();
    LEDTimer.reset();
    pc.printf(PROGNAME);
    
    while(true) {    
        if (LEDTimer.read_ms() > timeToChangeDF){ // check for timer time out transtion
            lightData = (1.0 - LightSensor.read()); // show as increasing with increasing intensity  
            sprintf(lcdData,"%4.3f",lightData);
            LCDMess(lcdData);
            gled = 1.0 - lightData;   //green light changes intensity as light data changes
            rled = 1.0 - lightData;   //red light changes intensity as light data changes
            timeToChangeDF = DATATIME;
            LEDTimer.reset();
        }        
    }// end while
}


