#include "mbed.h"
#include "TSISensor.h"
#include "SLCD.h"
#define TSILIMIT 0.99
#define LCDCHARLEN 10
#define DATAINTERVAL 0.1
#define PROGNAME "kl46z_slider_test_v1\n\r"

SLCD slcd; //define LCD display
Serial pc(USBTX, USBRX);
Timer DataI;

float tsidata;

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
}

void initialize_global_vars(){
    DataI.start();
    DataI.reset();
    }

int main(void) {
    char lcdData[LCDCHARLEN];
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);
    pc.printf(PROGNAME);
    TSISensor tsi;

     while (true) {
        tsidata = tsi.readPercentage();
        if (tsidata > TSILIMIT){
            gled = 0.0;
            rled = 0.0;
        }else {
            pc.printf("\n Position %f\n\r", tsidata);
            sprintf (lcdData,"%0.4f",tsidata);  
            LCDMess(lcdData);  
            gled = tsidata;
            rled = 1.0 - tsidata;
        }
           // wait(DATAINTERVAL);
           DataI.start();//Start timer
           if (DataI > DATAINTERVAL){//if the timer data is greater than the data internval
               DataI.reset();//Reset timer
               }
               
            if (tsidata = tsidata + 0.01){ //if the touch pos value is increased by 0.01
                pc.printf("\n Position value increased by 0.01: \n\r", tsidata); //then print the position value increase
                }
    }
}