#include "mbed.h"
#include <math.h> 
#include "MMA8451Q.h"
#include "SLCD.h"
#define NUMBUTS 2   //two buttons
#define LBUT PTC12 //left button // port addresses for buttons
#define RBUT PTC3 //right button

/* 
Test of the accelerometer, digital I/O, on-board LCD screen.
 Looing at vector product of the x-y components of the accelerometer.
 Works pretty well. Still rough, program wise - sc 140710
 */

//#define DATAINTERVAL 0.200
#define DATAINTERVAL 1.0
#define LCDDATALEN 10
#define BUTTONTIME 0.2
#define PROGNAME "KBrat-SSD541-HW-15.1\r\n"

#define PRINTDBUG

//----------------------------//



//----------------------------//

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;  // Data pins for the accelerometer/magnetometer.
  PinName const SCL = PTE24;  // DO NOT CHANGE
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

SLCD slcd; //define LCD display
char lcdData[LCDDATALEN]; //buffer needs places dor decimal pt and colon

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX);// set up USB as communicationis to Host PC via USB connectons
Timer ButtonTimer; // for reading button states

DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 

void LCDsignedFloat(float theNumber){
    sprintf (lcdData," %3.2f",theNumber); 
    if (theNumber < 0.0) sprintf (lcdData,"<%3.2f",fabs(theNumber));   
    LCDMess(lcdData); 
} 

void initialize_global_vars(){
    pc.printf(PROGNAME); 
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset(); 
} 


int main() {
    float xAcc;
    float yAcc; 
    float zAcc; 
    
    //initialize_global_vars();
    
    int i; 

    initialize_global_vars(); //keep things organized

// End of setup
    while(true) {
        if (ButtonTimer > BUTTONTIME){
            for (i=0; i<NUMBUTS; i++){ // index will be 0 or 1 
                if(!buttons[i]) {
                    if (i==1)
                        xAcc = acc.getAccX();
                        yAcc = acc.getAccY(); 
                        zAcc = acc.getAccZ();     

                        slcd.printf("X");
                        wait(0.3);
                        slcd.clear();
                        pc.printf("xAcc = %f\r\n", xAcc);
                        LCDsignedFloat(xAcc);
                        wait(1.5);
                        
                        slcd.printf("Y");
                        wait(0.3);
                        slcd.clear();
                        pc.printf("yAcc = %f\r\n", yAcc);
                        LCDsignedFloat(yAcc);
                        wait(1.5);
                        
                        slcd.printf("z");
                        wait(0.3);
                        slcd.clear();
                        pc.printf("zAcc = %f\r\n", zAcc);
                        LCDsignedFloat(zAcc);

// Wait then do the whole thing again.


                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
        }
       
    }
    
}






