//uvoz biblioteka
#include "mbed.h"

//definisanje direktiva
#define PAUSE 10
#define PERCENTAGE 100

//definisanje glavnih promenljivih
PwmOut buzzer(PA_11);
AnalogIn pot1(PA_0);
AnalogIn pot2(PA_1);
BusOut display(PA_10, PA_9, PA_8, PB_10, PB_5, PB_4, PB_3);
DigitalOut first(PB_6);
DigitalOut second(PC_7);
InterruptIn sw1(PC_9);

//pomoćne funkcije
void ISR_sw1(void);

//galvna funkcija
int main()
{
    while(true)
    {
        sw1.fall(&ISR_sw1);
        buzzer.period_us(pot2.read() * 2000 + PERCENTAGE);
        buzzer.write(pot1.read());
        wait_ms(PAUSE);
        
        
    }
}

void ISR_sw1()
{
        while(!sw1)
        {
            if(pot1.read()*PERCENTAGE < 10 && pot1.read()>-1)
        {
            first.write(1);
            int m = pot1.read()* PERCENTAGE;
            switch(m)
            {
                case 0: second.write(0); display.write(0xC0); wait_ms(PAUSE); second.write(1);break;
                case 1: second.write(0); display.write(0xF9); wait_ms(PAUSE); second.write(1);break;
                case 2: second.write(0); display.write(0xA4); wait_ms(PAUSE); second.write(1);break;
                case 3: second.write(0); display.write(0xB0); wait_ms(PAUSE); second.write(1);break;
                case 4: second.write(0); display.write(0x99); wait_ms(PAUSE); second.write(1);break;
                case 5: second.write(0); display.write(0x92); wait_ms(PAUSE); second.write(1);break;
                case 6: second.write(0); display.write(0x82); wait_ms(PAUSE); second.write(1);break;
                case 7: second.write(0); display.write(0xF8); wait_ms(PAUSE); second.write(1);break;
                case 8: second.write(0); display.write(0x80); wait_ms(PAUSE); second.write(1);break;
                case 9: second.write(0); display.write(0x90); wait_ms(PAUSE); second.write(1);break;
                default: break;      
            }   
        }
        
        if(pot1.read()*100 > 9)
        { 
            int x = pot1.read()*100;
            int n = x / 10;
            int s = x % 10;
            switch(n)
            {
                case 0: first.write(0); display.write(0xC0); wait_ms(PAUSE); first.write(1);break;
                case 1: first.write(0); display.write(0xF9); wait_ms(PAUSE); first.write(1);break;
                case 2: first.write(0); display.write(0xA4); wait_ms(PAUSE); first.write(1);break;
                case 3: first.write(0); display.write(0xB0); wait_ms(PAUSE); first.write(1);break;
                case 4: first.write(0); display.write(0x99); wait_ms(PAUSE); first.write(1);break;
                case 5: first.write(0); display.write(0x92); wait_ms(PAUSE); first.write(1);break;
                case 6: first.write(0); display.write(0x82); wait_ms(PAUSE); first.write(1);break;
                case 7: first.write(0); display.write(0xF8); wait_ms(PAUSE); first.write(1);break;
                case 8: first.write(0); display.write(0x80); wait_ms(PAUSE); first.write(1);break;
                case 9: first.write(0); display.write(0x90); wait_ms(PAUSE); first.write(1);break;
                default: break;
                
            }
            switch(s)
            {
                case 0: second.write(0); display.write(0xC0); wait_ms(PAUSE); second.write(1);break;
                case 1: second.write(0); display.write(0xF9); wait_ms(PAUSE); second.write(1);break;
                case 2: second.write(0); display.write(0xA4); wait_ms(PAUSE); second.write(1);break;
                case 3: second.write(0); display.write(0xB0); wait_ms(PAUSE); second.write(1);break;
                case 4: second.write(0); display.write(0x99); wait_ms(PAUSE); second.write(1);break;
                case 5: second.write(0); display.write(0x92); wait_ms(PAUSE); second.write(1);break;
                case 6: second.write(0); display.write(0x82); wait_ms(PAUSE); second.write(1);break;
                case 7: second.write(0); display.write(0xF8); wait_ms(PAUSE); second.write(1);break;
                case 8: second.write(0); display.write(0x80); wait_ms(PAUSE); second.write(1);break;
                case 9: second.write(0); display.write(0x90); wait_ms(PAUSE); second.write(1);break;
                default: break;
                
            }
        
        }
        
        }
}