/* mbed GPS Module Library for C027-SARA-G350
 * Copyright (c) 2008-2010, sford
 * Copyright (c) 2014, Jianliang Gao  Based on 
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "GPS.h"

GPS::GPS(PinName tx, PinName rx, int Baud) : _gps(tx, rx) {
    _gps.baud(Baud);    
    longitude = 0.0;
    latitude = 0.0;        
}

int GPS::sample() {
//    char ns, ew, unit;
    char unit;
    int lock;

    while(1) {        
        getline();

        // Check if it is a GPGGA msg (matches both locked and non-locked msg)
        if(sscanf(msg, "GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f,%c,%f", &time, &latitude, &ns, &longitude, &ew, &lock, &sats, &hdop, &alt, &unit, &geoid) >= 1) { 
            if(!lock) {
                time = 0.0;
                longitude = 0.0;
                latitude = 0.0;
                sats = 0;
                hdop = 0.0;
                alt = 0.0;
                geoid = 0.0;        
                return 0;
            } else {
               
                float degrees = trunc(latitude / 100.0f);                
                float minutes = latitude - (degrees * 100.0f);
                latitude = degrees + minutes/60.0f;  
                if(ns == 'S') {    latitude  *= -1.0; }  
                
                degrees = trunc(longitude / 100.0f); 
                minutes = longitude - (degrees * 100.0f);
                longitude = degrees + minutes / 60.0f;
                if(ew == 'W') {    longitude *= -1.0; }
                return 1;
            }
        }
    }
}

float GPS::trunc(float v) {
    if(v < 0.0) {
        v*= -1.0;
        v = floor(v);
        v*=-1.0;
    } else {
        v = floor(v);
    }
    return v;
}

void GPS::getline() {
    while(_gps.getc() != '$');    // wait for the start of a line
    for(int i=0; i<256; i++) {
        msg[i] = _gps.getc();
        if(msg[i] == '\r') {
            msg[i] = 0;
            return;
        }
    }
    error("Overflowed message limit");
}

/* sample 
#include "mbed.h"
#include "GPS.h"
 
Serial pc(USBTX, USBRX);
GPS gps(P0_10, P0_11, 9600);

int main() {
    pc.baud(9600);
    
    while (1) {
        wait(3);
        pc.printf("hello, a test \n");
        gps.sample();
        pc.printf("GPS Sats number is %d \n", gps.sats);

        if (gps.ns == 'S')
           pc.printf("GPS Latitude = %.4f South;  ", gps.latitude * -1.0);
        else if (gps.ns == 'N')
           pc.printf("GPS Latitude = %.4f North;  ", gps.latitude);
        if (gps.ew == 'W')
           pc.printf("Longitude = %.4f  West;  ", gps.longitude * - 1.0);
        else if (gps.ew == 'E')  
           pc.printf("Longitude = %.4f  East;  ", gps.longitude);
        pc.printf("Alt = %.4f ", gps.alt);

        }
        
 
}
*/  //Enjoy it!