#include "mbed.h"
#include "EthernetInterface.h"
#include <string>

//RGB led
PwmOut r (D5);
PwmOut g (D8);
PwmOut b (D9);

DigitalOut led(LED1);

void select_state(){
        while(1){
                lcd.cls();
                lcd.locate(0,3);
                lcd.printf("Select State by moving the joystick \n");
                lcd.printf("And select by pressing the joystick \n");
                if(left) {
                    lcd.cls();
                    lcd.printf("The node is a reciever");
                    sender = false;
                    }
                if(right){
                    lcd.cls();
                    lcd.printf("The node is a sender");
                    sender = true;
                    }
                if(select){
                    lcd.cls();
                    break;
                    }
            }
    }

void select_reciever_id(){
        while(1){
                lcd.cls();
                lcd.locate(0,3);
                lcd.printf("Select reciever id by moving the joystick \n");
                lcd.printf("And select by pressing the joystick");
                if(left && id_of_reciever > 0) {
                    lcd.cls();
                    id_of_reciever -= 1;
                    lcd.printf("The reciever id is: ", id_of_reciever);
                    }
                if(right && id_of_reciever < 255){
                    lcd.cls();
                    id_of_reciever += 1;
                    lcd.printf("The reciever id is: ", id_of_reciever);
                    }
                if(select){
                    lcd.cls();
                    break;
                    }
            }
    }
    
void rgb_led(){
    r.period(0.001);
    while(1) {
        for(float i = buffer[2]/255; i < 1.0 ; i += 0.001) {
            float p = 3 * i;
            r = 1.0 - ((p < 1.0) ? 1.0 - p : (p > 2.0) ? p - 2.0 : 0.0);
            g = 1.0 - ((p < 1.0) ? p : (p > 2.0) ? 0.0 : 2.0 - p);
            b = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);  ;  
            wait (0.01);
            }
        }
    }

void display_temperature(){
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("The recieved temperature is: ", buffer[0]);
    lcd.printf(",", buffer[1]);
    }

void connect_server(int port) {
    printf("Server example\n\r");
    
    EthernetInterface eth;
    eth.set_network("192.168.0.40","255.255.255.0","192.168.0.1");
    eth.connect();
    
    printf("The Server IP address is '%s'\n\r", eth.get_ip_address());
    
    TCPServer srv(&eth);  
    
    srv.bind(port);
    
    srv.listen();
    }
    
void set_connection(){
        TCPSocket client;
        SocketAddress client_addr;
        
        srv.accept(&client, &client_addr);
        
        printf("Accepted %s:%d\n\r", client_addr.get_ip_address(), 
                    client_addr.get_port());
        }

int main()
{
        bool sender = false;
        char buffer[255];
        int i = 4; //value of i is 4 because the first 4 items in the buffer has already values stored(buffer[0],buffer[1],buffer[2],buffer[3],) so we have to add values starting with buffer[4]
        int id_of_reciever = 1;

    connect_server(4000); //connect server on port 4000
    
    while(true){        

        set_connection(); //connect with client
        
        select_state(); //Is the node sender/reciever?
        select_reciever_id(); //each node wether sender/reciever needs to select reciever id (round-robin)
        
        if(sender = false){
            do{
            int n = client.receive(buffer, sizeof(buffer));
            if(n > 0){ //Makes sure the packet is recieved
                size_t found = client_addr.get_ip_address().find_last_of("."); //find last '.' of the ip address ex. 192.168.0.13
                buffer[i] = client_addr.get_ip_address().substr(found+1); //Give the number after the last '.' in this ex. 13 that is the sender ID
                i++;
                                                                        //Other examples at: http://www.cplusplus.com/reference/string/string/find_last_of/
                client.send(buffer, sizeof(buffer));
                }
            display_temperature(); //Display recieved temperature of sender on lcd
            rgb_led(); //Display rgb_led with recieved pwm value of sender
            }while(buffer[3] != buffer[i]) //Keeps looping untill the ID of the first sender ID is the same
            
            }
        client.close(); //Stop communication with client
        
    }
}
