/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
************************************************************************
*
* Test of the Pmod small OLED display and ambient light sensor
*
*************************************************************************
* Description: Pmod_OLED_ALS1
* The message "Test module Pmod Digilent Lextronic" will be display on OLEDrgb module
* with different size and colors..... and sensor value as well.
*
* Material
* 1. ST L432KC  ( or some other micro controller board with SPI communication )
* 2. Digilent Pmod OLEDrgb  and the libraries
* Adafruit_SSD1331_Mbed
* Adafruit-GFX
* These libraries can be found with search on the page 
* https://www.mbed.com/en/platform/mbed-os/
* Please connect L432KC - Pmod_OLEDrgb with lines:
* L432KC D13 - OLED 4 SCK   hardware defined for the SPI
* L432KC D11 - OLED 2 MOSI  hardware definef for the SPI
* L432KC D9  - OLED 1 CS   or any other free
* L432KC D10 - OLED 7 DC   or any other free
* L432KC D6  - OLED 8 RES   or any other free
*  VCC     - OLED 9 VCCEN  Enable - VCC
*  VCC     - OLED10 PMODEN  Pmod Enable - VCC
*  GND     - OLED 5 Ground
*  VCC     - OLED 6 Power supply 3,3 V
* 
*************************************************************************
* 3. Digilent Pmod ALS ambient light sensor
* Please connect L432KC - PmodALS with lines:
* L432KC D13 - ALS 4 SCK   hardware defined for the SPI
* L432KC D12 - ALS 3 MISO  hardware defined for the SPI
* L432KC D4  - ALS 1 CS  or any other free
*  GND     - ALS 5 GND
*  Vcc     - ALS 6 Vcc

ALS data on the SPI
D15 ... D13 - three zeros
D12 ... D04 - 8 bits of ambient light data
D03 ... D00 - four zeros

Details on the connection of ADC IC chip on ALS board are given
http://www.ti.com/lit/ds/symlink/adc081s021.pdf
* 
* Timo Karppinen 16.05.2020   Apache-2.0
**************************************************************/


#include "mbed.h"
#include "Adafruit_SSD1331.h"   // By using the Adafruit SSD1331 library and Adafruit GFX library
#include "Adafruit_GFX.h"       // we will get similar code than in Arduino-boards working.
                                // There are other SSD1331 libraries, too. https://os.mbed.com/search/?q=ssd1331
                            
// PmodOLEDrgb
Adafruit_SSD1331 OLED(D9, D6, D10, D11, NC, D13); // cs, res, dc, mosi, (nc), sck  

//DigitalOut LED(LED1); // LED1, LED2, LED3 and LED4 are the D13 PB_3 pin in this board and can not be used because of the SPI
DigitalOut VCCEN(D3);
DigitalOut PMODEN(D5);

// Definition of colors on the OLED display
#define Black 0x0000
#define Blue 0x001F
#define Red 0xF800
#define Green 0x07E0
#define Cyan 0x07FF
#define Magenta 0xF81F
#define Yellow 0xFFE0
#define White 0xFFFF

// PmodALS
SPI spi(D11, D12, D13); // mosi, miso, sck
 

DigitalOut alsCS(D4);        // chip select for sensor SPI communication
char alsByte0 = 0;           // 8 bit data from sensor board, char is the unsigned 8 bit
char alsByte1 = 0;           // 8 bit data from sensor board
char alsByteSh0 = 0;
char alsByteSh1 = 0;
char als8bit = 0;
unsigned short alsRaw = 0;   // unsigned 16 bit
float alsScaledF = 0;       // 32 bit floating point
void getALS();


char Time[50],Date[50];
void getTime();
int first = 0;

int main()
{
  // Showing with a LED that program has started
        //    LED = 0;
        VCCEN = 1;    // if you did not connect VCCEN permanently to Vcc
        PMODEN = 1;   // if you did not connect PMODEN permanently to Vcc
        ThisThread::sleep_for(2000);
        //    LED = 1;
        ThisThread::sleep_for(2000);
        //  LED = 0;
  // Initalize the PmodOLEDrgb    
        OLED.begin(); // initialization of display object
        
// SPI for the ALS      
        alsCS = 1;
        // Setup the spi for 8 bit data, high steady state clock,
        // second edge capture, with a 12MHz clock rate
        spi.format(8,0);           
        spi.frequency(12000000);
        
        OLED.clearScreen();   

    while (true) {
        while(first < 3)
            {
                first += 1; 
                OLED.fillScreen(Black); // background screen in black
                OLED.setTextColor(Cyan); // color of text in cyan
                OLED.setCursor(0,0); // cursor is in x=0 and y=15
                OLED.printf("Test module Pmod"); // display text
                ThisThread::sleep_for(500); // wait 500 ms
                OLED.setCursor(0,15); // cursor is in x=0 and y=15
                OLED.setTextSize(2); // size of text
                OLED.setTextColor(Red); // text in red color
                OLED.printf("DIGILENT"); // display text
                OLED.setCursor(20,40); // cursor is in x=20 and y=40
                OLED.setTextSize(1); // size of text
                OLED.setTextColor(Green); // text in green color
                OLED.printf("LEXTRONIC"); // display text
                OLED.drawFastHLine(1, 60, OLED.width()-1, Blue); // blue line x=1 to screen width-1 and y=60
                ThisThread::sleep_for(2000); // wait 2 s
                OLED.fillScreen(Black); // background display in black (erase display)
                OLED.fillRoundRect(5, 5, 30, 40, 1, Blue); // French flag bleu blanc rouge
                OLED.fillRoundRect(35, 5, 30, 40, 1, White);
                OLED.fillRoundRect(65, 5, 30, 40, 1, Red);
                OLED.fillCircle(90, 55, 5, Yellow); // yellow circle with radius=5 in x=90 and y=55
                ThisThread::sleep_for(2000); // wait 2 s
            }

        getTime();
        OLED.clearScreen();
        OLED.fillScreen(Black); // background screen in black
        OLED.setTextColor(Cyan); // color of text in cyan
        ThisThread::sleep_for(300);
        OLED.setCursor(0,0); // cursor is in x=0 and y=0
        OLED.printf("Rec '%s' \n",Time);
        
        getALS(); 
        OLED.printf("LUX = '%0.1f' \n",alsScaledF);

        if (alsScaledF > 100)
        { 
            OLED.setTextColor(Yellow);
            OLED.printf("Be aware of high UV radiation!");
            OLED.fillRoundRect(10, 35, 50, 3 , 1, Yellow);
        }
        OLED.setCursor(0,40); // cursor is in x=0 and y=0
        OLED.printf("Test completed");
        OLED.drawFastHLine(1, 60, OLED.width()-1, Blue); // blue line x=1 to screen width-1 and y=60
        printf("printed on OLED");
        
        ThisThread::sleep_for(3000);
}
}

void getTime()
{    
    time_t seconds = time(NULL);
    strftime(Time,40,"%H:%M:%S", localtime(&seconds));
    strftime(Date,40,"%d-%b-%Y", localtime(&seconds));
    printf("Recorded '%s' \r\n",Time);
}

void getALS()
{
    alsCS = 0; 
    
    alsByte0 = spi.write(0x00);
    alsByte1 = spi.write(0x00);
  
    alsCS = 1;
   
    alsByteSh0 = alsByte0 << 4;
    alsByteSh1 = alsByte1 >> 4;
    
    als8bit =( alsByteSh0 | alsByteSh1 );
    
    alsRaw = als8bit; // 
    alsScaledF = (float(alsRaw))*(float(6.68)); // The value 6.68 is 64 bit double precision floating point of type double.
                                                // Conversions to 32 bit floating point of type float.
    printf("Ambient light raw 8 bit 0...255 =  '%d' \r\n",alsRaw);
    printf("Ambient light scaled to LUX =  '%0.1f' \r\n",alsScaledF);
    ThisThread::sleep_for(100);
}

