/*
 * Copyright (c) 2006-2020 Arm Limited and affiliates.
 * SPDX-License-Identifier: Apache-2.0
 ***********************************
 * NTP time client example
 * A microcontroller board with an Ethernet interface
 * NXP FRDM-K64F used for testing
 *   
 * Timo Karppinen 14.9.2020
 ***********************************/
#include "mbed.h"
#include "EthernetInterface.h"
#include "ntp-client/NTPClient.h"

//Network interface
EthernetInterface net;

//NTP server is a time server used for delivering timing information for networks.
// Returns 32 bits for seconds and 32 bits for fraction of seconds. 
//#define ntpAddress "2.pool.ntp.org"
#define ntpAddress "time.mikes.fi"  // The VTT Mikes in Helsinki
#define ntpPort 123
    
int main() {
    printf("\nNTP Client example (using Ethernet)\r\n");
    
    //Bring up the network interface
    net.connect();
    
    // Show network address
    SocketAddress netAddress;
    net.get_ip_address(&netAddress);
    printf("\n\nClient IP Address: %s\n", netAddress.get_ip_address() ? netAddress.get_ip_address():"None");

    NTPClient ntp(&net);
    
    ntp.set_server(ntpAddress, ntpPort);
      
    for(int i=0; i<5; i++){
        time_t timestamp = ntp.get_timestamp();
        
        if (timestamp < 0) {
            printf("An error occurred when getting the time. Code: %u\r\n", timestamp);
        } else {
            printf("The timestamp seconds from the NTP server in\r\n  32 bit hexadecimal number is %X\r\n", timestamp);
            printf("  decimal number is %u\r\n", timestamp);
            timestamp += (60*60*3);  //  GMT +3  for Finland for the summer time.
            printf("Current time is %s\r\n", ctime(&timestamp));
        }
        
        printf("Waiting for 10 seconds before trying again...\r\n");
        ThisThread::sleep_for(10s);  
    }  
    printf("Did it succeed to get correct time?\n If not the port might be blocket on the firewall.\n");
    ThisThread::sleep_for(30s);  

    while(1) {  
        printf("\nWe stopped sending more UDP packets to the server.\nUnplug your device!\n");
        ThisThread::sleep_for(3s);
    }
    
}