/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
************************************************************************
*
* Commissioning test for the L432KC and the Pmod small OLED display
*
*************************************************************************
* Description: McLab10_OLEDrgb_L432KC
* "Test module Pmod Digilent Lextronic" will be displayed on OLEDrgb module
* with different size and colors..... and later the variable values.
*
* Material
* 1. ST L432KC  ( or some other micro controller board with SPI communication )
* 2. Digilent Pmod OLEDrgb  and the libraries
* Adafruit_SSD1331_Mbed
* Adafruit-GFX
* These libraries can be found with search on the page 
* https://www.mbed.com/en/platform/mbed-os/
* Please connect L432KC - Pmod_OLEDrgb with lines:
* L432KC D13 - OLED 4 SCK   hardware defined for the SPI
* L432KC D11 - OLED 2 MOSI  hardware definef for the SPI
* L432KC D9  - OLED 1 CS   or any other free
* L432KC D10 - OLED 7 DC   or any other free
* L432KC D6  - OLED 8 RES   or any other free
*  VCC     - OLED 9 VCCEN  Enable - VCC
*  VCC     - OLED10 PMODEN  Pmod Enable - VCC
*  GND     - OLED 5 Ground
*  VCC     - OLED 6 Power supply 3,3 V
* 
*************************************************************************
* Compiles OK, works with hardware with operating system revision 6691:cf4f12a 
* Compiles OK, DOESN'T WORK with hardware with op sys revision 7088:3ab72c7 
* Timo Karppinen 28.08.2020
**************************************************************/

#include "mbed.h"
#include "Adafruit_SSD1331.h"   // By using the Adafruit SSD1331 library and Adafruit GFX library
#include "Adafruit_GFX.h"       // we will get similar code than in Arduino-boards working.
                                // There are other SSD1331 libraries, too. 
                                // https://os.mbed.com/search/?q=ssd1331  
                                // The tested are:
                                // Adafruit_SSD1331_Mbed by Marijn Romeijn
                                // Adafruit_GFX by Team_EIC                  
// PmodOLEDrgb
Adafruit_SSD1331 OLED(D9, D6, D10, D11, NC, D13); // cs, res, dc, mosi, (nc), sck  

//DigitalOut LED(LED1);     // LED1, LED2, LED3 and LED4 are the D13 PB_3 pin in this board and 
                            //can not be used because of the SPI
DigitalOut VCCEN(D3);
DigitalOut PMODEN(D5);

// Definition of colours on the OLED display
#define Black 0x0000
#define Blue 0x001F
#define Red 0xF800
#define Green 0x07E0
#define Cyan 0x07FF
#define Magenta 0xF81F
#define Yellow 0xFFE0
#define White 0xFFFF

float stepsScaledF = 0;       // 32 bit floating point
void getSTEPS();

char Time[50],Date[50];
void getTime();
int first = 0;

int main()
{
  // Showing with a LED that program has started
        //    LED = 0;
        VCCEN = 1;    // if you did not connect VCCEN permanently to Vcc
        PMODEN = 1;   // if you did not connect PMODEN permanently to Vcc
        ThisThread::sleep_for(2000);
        //    LED = 1;
        ThisThread::sleep_for(2000);
        //  LED = 0;
  // Initalize the PmodOLEDrgb    
        OLED.begin(); // initialization of display object
        
        OLED.clearScreen();   

    while (true) {
        while(first < 3)
            {
                first += 1; 
                OLED.fillScreen(Black); // background screen in black
                OLED.setTextColor(Cyan); // colour of text in cyan
                OLED.setCursor(0,0); // cursor is in x=0 and y=15
                OLED.printf("Test module Pmod"); // display text
                ThisThread::sleep_for(500); // wait 500 ms
                OLED.setCursor(0,15); // cursor is in x=0 and y=15
                OLED.setTextSize(2); // size of text
                OLED.setTextColor(Red); // text in red colour
                OLED.printf("DIGILENT"); // display text
                OLED.setCursor(20,40); // cursor is in x=20 and y=40
                OLED.setTextSize(1); // size of text
                OLED.setTextColor(Green); // text in green colour
                OLED.printf("LEXTRONIC"); // display text
                OLED.drawFastHLine(1, 60, OLED.width()-1, Blue); //blue line x=1, width-1 and y=60
                ThisThread::sleep_for(2000); // wait 2 s
                OLED.fillScreen(Black); // background display in black (erase display)
                OLED.fillRoundRect(5, 5, 30, 40, 1, Blue); // French flag bleu blanc rouge
                OLED.fillRoundRect(35, 5, 30, 40, 1, White);
                OLED.fillRoundRect(65, 5, 30, 40, 1, Red);
                OLED.fillCircle(90, 55, 5, Yellow); // yellow circle with radius=5 in x=90 and y=55
                ThisThread::sleep_for(2000); // wait 2 s
            }

        getTime();
        OLED.clearScreen();
        OLED.fillScreen(Black); // background screen in black
        OLED.setTextColor(Cyan); // colour of text in cyan
        ThisThread::sleep_for(300);
        OLED.setCursor(0,0); // cursor is in x=0 and y=0
        OLED.printf("Rec '%s' \n",Time);
        
        getSTEPS(); 
        OLED.printf("value = '%0.1f' \n",stepsScaledF);

        if (stepsScaledF > 2.00)
        { 
            OLED.setTextColor(Yellow);
            OLED.printf("Be aware of reaching the limit");
            OLED.fillRoundRect(10, 35, 50, 3 , 1, Yellow);
        }
        OLED.setCursor(0,40); // cursor is in x=0 and y=0
        OLED.printf("Wait a moment !");
        OLED.drawFastHLine(1, 60, OLED.width()-1, Blue); // blue line x=1 to screen width-1 and y=60
        printf("printed on OLED");
        
        ThisThread::sleep_for(3000);
}
}

void getTime()
{    
    time_t seconds = time(NULL);   //  https://os.mbed.com/docs/mbed-os/v6.2/apis/time.html
    strftime(Time,40,"%H:%M:%S", localtime(&seconds));
    strftime(Date,40,"%d-%b-%Y", localtime(&seconds));
    printf("Recorded '%s' \r\n",Time);
}

void getSTEPS()
{
    static int count; 
   
    count = count + 100;
    if (count > 4095){
        count = 0;
        }
    
    stepsScaledF = (float(count))*(float(2.50)/4095); // The value 2.50 is 64 bit double precision floating point of type double.
                                                // Conversions to 32 bit floating point of type float.
    printf("Counter value '%d' \r\n",count);
    printf("Scaled output  '%0.1f' \r\n",stepsScaledF);
    ThisThread::sleep_for(100);
}