/*
The MAX32630FTHR is included in the Mbed OS. No need to include 
the library max32630fthr !
Just look at
https://github.com/ARMmbed
Select mbed-os or directly https://github.com/ARMmbed/mbed-os
Select folder targets
Select folder TARGET_Maxim
Select folder TARGET_MAX32630

SPI pin, PWM pin definitions
https://github.com/ARMmbed/mbed-os/blob/master/targets/TARGET_Maxim/TARGET_MAX32630/PeripheralPins.c

The PwmOut voltage rises from 0.0 V up to 1.8 V and the DigitalOut voltages are
0.0 V and 1.8 V .

Timo Karppinen 20.12.2021
********************************************************/

#include "mbed.h"

//DigitalOut rLED(P5_4);
PwmOut rLED(P5_4);
DigitalOut gLED(P5_5);
int ledStatus = false;
float intensity;

int main()
{
    gLED = true;
    //rLED = true;
    rLED.period_us(100);
    rLED.write(1.0);

    ThisThread::sleep_for(1000ms);
    //rLED = false;
    rLED.write(0.1);
    printf("Initialized.\n");

    while (true) {
        gLED = !gLED;
        ledStatus = gLED.read();
        printf("The gLED status is %d\n", ledStatus);
        
        for(int i = 0; i < 5; i++){
            intensity = 0.25 * float(i);
            rLED.write(intensity);
            ThisThread::sleep_for(500ms);
            }
        ThisThread::sleep_for(2000ms);    
    }
}