/*   
 * Copyright 2011 Timothy Goh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "HT1632.h"

HT1632::HT1632(PinName d1, PinName d2, PinName d3, PinName d4) : _spi(d1, d2, d3), _cs(d4) {
    _spi.format(12,3);
    _spi.frequency(5000000);
    _numbits = BITS12;
    _cs = 1;
    write12(SYS_EN);
    write12(RC_MASTER_MODE);
    write12(N_MOS_COM8);
    write12(PWM_16);
    write12(LED_ON);
}

void HT1632::drawnibble(uint8_t address, uint8_t data) {
    write14(0x2800 | (address<<4) | (data & 0x0f));
}

void HT1632::drawbyte(uint8_t address, uint8_t data) {
    if (_numbits != BLOCK8) {
        _numbits = BLOCK8;
    }        
    _spi.format(10,3);
    _cs = 0;
    _spi.write(0x280 | address);
    _spi.format(8,3);
    _spi.write(data);
    _cs = 1;
}


void HT1632::drawbuf(uint8_t address, uint8_t* data, uint8_t count) {
    if (_numbits != BLOCK8) {
        _numbits = BLOCK8;
    }        
    _spi.format(10,3);
    _cs = 0;
    //Address is divided due to native nibble addressing
    _spi.write(0x280 | address<<1);
    _spi.format(8,3);
    while(count != 0){
        _spi.write(*data);
        data++;
        count--;
    }
    _cs = 1;
}

void HT1632::write12(uint16_t data) {
    if (_numbits != BITS12) {
        _spi.format(12,3);
        _numbits = BITS12;
    }
    _cs = 0;
    _spi.write(data);
    _cs = 1;
}

void HT1632::write14(uint16_t data) {
    if (_numbits != BITS14) {
        _spi.format(14,3);
        _numbits = BITS14;
    }
    _cs = 0;
    _spi.write(data);
    _cs = 1;
}