#include "globals.h"

extern "C" int itask( unsigned int *, void (void) );
extern "C" int run_task( unsigned int *, unsigned int);
extern "C" int sleep_task( unsigned int, unsigned int * );

extern "C" {
//------------------------------
void install_task0( void task(void) )
 {
  sp0 = itask( &taskstack0[255], task);
 }
}   //end of extern "C"

//------------------------------
extern "C" {
void install_task1( void task(void) )
{
 sp1 = itask( &taskstack1[255], task);
}
}   //end of extern "C"

//------------------------------
extern "C" {
void install_task2(void task(void) )
{
 sp2 = itask( &taskstack2[255], task);
}
}   //end of extern "C"

//------------------------------
extern "C" {
void install_task3( void task(void) )
{
 sp3 = itask( &taskstack3[255], task);
}
}   //end of extern "C"

//------------------------------
extern "C" {
void install_task4( void task(void) )
{
 sp4 = itask( &taskstack4[255], task);
}
}   //end of extern "C"

//------------------------------
extern "C" {
void install_task5( void task(void) )
{
 sp5 = itask( &taskstack5[255], task);
}
}   //end of extern "C"

//------------------------------
extern "C" {
void run_task0( void )
{
 task_number = 0; 
 run_task( &savesp, sp0 );
}
}   //end of extern "C"

//------------------------------
extern "C" {
void run_task1( void )
{
 task_number = 1;
 run_task( &savesp, sp1 );
}
}   //end of extern "C"

//------------------------------
extern "C" {
void run_task2( void )
{
 task_number = 2;
 run_task( &savesp, sp2 );
}
}   //end of extern "C"

//------------------------------
extern "C" {
void run_task3( void )
{
 task_number = 3;
 run_task( &savesp, sp3 );
}
}   //end of extern "C"

//------------------------------
extern "C" {
void run_task4( void )
{
 task_number = 4;
 run_task( &savesp, sp4 );
}
}   //end of extern "C"

//------------------------------
extern "C" {
void run_task5( void )
{
 task_number = 5;
 run_task( &savesp, sp5 );
}
}   //end of extern "C"

//------------------------------
extern "C" {
void sleep( void ) {
 switch( task_number )
  {
   case 0:
    sleep_task( savesp, &sp0 );
    break;
   
   case 1:
    sleep_task( savesp, &sp1 );
    break;
   
   case 2:
    sleep_task( savesp, &sp2 );
    break;
   
   case 3:
    sleep_task( savesp, &sp3 );
    break;
    
   case 4:
    sleep_task( savesp, &sp4 );
    break;
    
   case 5:
    sleep_task( savesp, &sp5 );
    break;
  }
}
}   //end of extern "C"
//------------------------------

