//serial port receiver interrupt handler

#include "globals.h"

Serial Terminal(p9, p10 );   

extern "C" void sleep( void );

//---------------------------------------------------------------------
extern "C" {
void serial_rx_isr( void )
{
 rxbuffer[rxwr++] = Terminal.getc();    //get character
 rxwr &= 0xff;                                //range check index
}
}   //end of extern "C"

//-----------------------------------------------------
extern "C" {
int put_char( char c )
{ 
  while( !Terminal.writeable() ) sleep();
  Terminal.putc(c);
  if ( c == 0xa )
   {
     while( !Terminal.writeable() ) sleep();
     Terminal.putc(0xd);
   }
  
  return( c );
}
}   //end of extern "C"

//-------------------------------------------
extern "C" {
void sleepy_write( char *ptr)
 {
    char c;
    
    while( c = *ptr++ ) put_char( c ); 
  }
}   //end of extern "C"

//----------------------------------------------------------------------
extern "C" {
int get_char( void )
 {
   char c;
   
   while( (rxwr == rxrd) ) sleep();
   
   c = rxbuffer[rxrd++];
   rxrd &= 0xff;                                   //keep in range
   return(c);
 }
}   //end of extern "C"
 
//-----------------------------------------------------------------------
extern "C" {
int peekchar( void )
 {  
   if( rxwr == rxrd ) return(0);
   return(1);
 }
}   //end of extern "C"

//------------------------------------------------------
extern "C" {
void crlf( void )
{
 put_char(0xa);
 put_char(0xd);
}
}   //end of extern "C"

//------------------------------------------------------
extern "C" {
void spaces( unsigned char i )
{
 if ( i > 0 ) {while(i--) put_char(0x20);}
}
}   //end of extern "C"

//-----------------------------------------------------------------
// parse text line, converting ' ' and 'CR' to NULL
// returns global argv and argc parameters set accordingly
extern "C" {
void parse( char *ptr )
  {    
    argc = 0;
    while( *ptr )
      {
        argv[argc++] = ptr;        //record start of parameter string
        while(*ptr != ' ') ptr++;
        *ptr++ = 0;
      }     
  }
}   //end of extern "C"
  
//-----------------------------------------------------------------------
extern "C" {
void readln( char *ptr )
  {
    char key;
    int count = 0;   
    
    while(1) 
      {
        key = get_char();
        
        if ( key == 0xd )
          {
            *ptr++ = 0x20;
            *ptr = 0;
            return;
          }
        
        if ( key == 0x1b )        //esc
          {
            *ptr++ = 'q';
            *ptr++ = 0x20;
            *ptr = 0;
//            put_char(0xa);
            return;
          }
          
        if ( key == 0x8 )        //delete
          {
            if ( count )
              {
                put_char( 0x8 );
                put_char( 0x20 );
                put_char( 0x8 );
                ptr--;
                count--;
              }
          }
        else
          {
            *ptr++ = key;
            count++;
            put_char( key );
          }
      }
  }
}   //end of extern "C"
   
//--------------------------------------------------------------------------
extern "C" {
void goxy( int x, int y)
  {
    sprintf(sl_buff,"%c[%d;%dH", 27, y, x); sleepy_write( sl_buff); 
  }
}   //end of extern "C"

//--------------------------------------------------------------------------
extern "C" {
void cursor( int x, int y, int spaces )
  {
    goxy( x, y );
    while( spaces-- ) put_char( ' ' );
    goxy( x, y );
  }
}   //end of extern "C"
  
//--------------------------------------------------------------------------
extern "C" {
void clear_screen( void )
  {
    sprintf(sl_buff,"%c[2J", 27); sleepy_write( sl_buff);  /* erase screen */
  }
}   //end of extern "C"
  
//-------------------------------------------------------------------------
extern "C" {
int tohex( char c )
  {
    if ( c > 0x39 ) c-=7;
    return( c&0xf );
  }
}   //end of extern "C"
  
//-------------------------------------------------------------------------
extern "C" {
int atohex( char *ptr )
  {
    int acc = 0;
    int nibble;
    
    while( nibble = *ptr++ )
      {
        acc*=16;
        acc+=tohex(nibble);
      }
    
    return( acc );
  }

}   //end of extern "C"
