#include "globals.h"

extern "C" void sleep(void);
extern "C" void serial_rx_isr(void);
extern "C" void display_screen( void );
extern "C" void update_data( void );
extern "C" void readln( char *);
extern "C" void parse( char * );
extern "C" int peekchar( void );
extern "C" int get_char( void );
extern "C" void crlf( void );
extern "C" void sleepy_write( char *);

extern Serial Terminal;


//----------------------------------------------------------------------
extern "C" {

void lredo_screen( void )
{
  redraw = 1;
}
}//end of extern "C"


//----------------------------------------------------------------------
extern "C" {

void cli( char **options, void (*routines[])( void ) ) 
  {
    int i;
   
    if ( strlen( *argv ) == 0 ) return;
    
    i = 0;
    while( *options )
      {
        if ( strcmp( *argv, *options++ ) == 0 )
          {
            routines[i]();
            redraw = 1;
            return;
          }
        i++;
      }
  }
}//end of extern "C"

//----------------------------------------------------------------------
char *main_options[] =
  {
    "j",
   0
  };
  
void (*main_routines[])( void ) = 
  {
    lredo_screen,
    0
  };
  
//--------------------------------------------
extern "C" {

void user( void)
{
    
    Terminal.attach( serial_rx_isr, Serial::RxIrq );
    
    redraw = TRUE;
    while(1)
     {
      if ( redraw ) display_screen();
      update_data();
      readln( rxline );
      parse( rxline );
      cli( main_options, main_routines);
     }
  
}

}//end of extern "C"
