#include "mbed.h"
#include "MMA8451Q_tb.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)

DigitalOut myled(LED_GREEN);
PwmOut pwm1(PTD4);
PwmOut pwm2(PTA12);
Serial pc(USBTX, USBRX);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

float x,y,z, mag;
float rstart1 = 0.028;
float rend1 = 0.118;
float rstart2 = 0.022;
float rend2 = 0.114;

float degx, range1, pwm_val, temp;
float blah = 0.022;
float scale1 = 0.002;

int main() {
    pc.baud(115200);    
    range1 = rend1 - rstart1;
    pwm1 = 0.073;
    pwm2 = 0.068;
             
    while (true) {
        wait(.001);
        
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        pc.printf("X: %4.6f, Y: %4.6f, Z: %4.6f \n", x, y, z);
        
        /*
        pwm1 = 0.073 + x*0.045;
        pwm2 = 0.068 - y*0.046;
        
        degx = asin(x)*180/3.1416;
        temp = (degx+90)*0.0005 + 0.028;
        pwm1 = temp;
        pc.printf("degX: %4.6f, pwm1: %4.6f \n", degx, temp);
        */
        
        if (x > 0.1) {
            pwm1 = pwm1 + scale1*abs(x);
        }
        if (x < -0.1) {
            pwm1 = pwm1 - scale1*abs(x);
        }
        
        if (z > 0.1) {
            pwm2 = pwm2 + scale1*abs(z);
        }
        if (z < -0.1) {
            pwm2 = pwm2 - scale1*abs(z);
        }
        //myled = !myled;
    }
}
        /*
        blah = blah + 0.002;
        if (blah > 0.2) {
            blah = 0.08;
            wait(1);
        }
        pwm1 = blah;
        pc.printf("pwm1: %4.3f \n", blah);                   
        */