#include "MMA8451Q_tb.h"

#define REG_WHO_AM_I        0x0D
#define XYZ_DATA_CFG        0x0E
#define REG_OUT_X_MSB       0x01
#define REG_OUT_Y_MSB       0x03
#define REG_OUT_Z_MSB       0x05
#define REG_SYSMOD          0x0B
#define REG_CTRL_REG1       0x2A

#define UINT14_MAX          16383


MMA8451Q::MMA8451Q(PinName sda, PinName scl, int addr) : m_i2c(sda, scl), m_addr(addr) {
    // activate the peripheral
    uint8_t data[2] = {REG_CTRL_REG1, 0x01};
    writeRegs(data, 2);
}

MMA8451Q::~MMA8451Q() { }

uint8_t MMA8451Q::getWhoAmI() {
    uint8_t who_am_i = 0;
    readRegs(REG_WHO_AM_I, &who_am_i, 1);
    return who_am_i;
}

float MMA8451Q::getAccX() {
//divide by 4096 b/c MMA output is 4096 counts per g so this f outputs accelorometer value formatted to g (gravity)
    return (float(getAccAxis(REG_OUT_X_MSB))/4096.0);
}

float MMA8451Q::getAccY() {
    return (float(getAccAxis(REG_OUT_Y_MSB))/4096.0);
}

float MMA8451Q::getAccZ() {
    return (float(getAccAxis(REG_OUT_Z_MSB))/4096.0);
}

void MMA8451Q::getAccAllAxis(float * res) {
    res[0] = getAccX();
    res[1] = getAccY();
    res[2] = getAccZ();
}

int16_t MMA8451Q::getAccAxis(uint8_t addr) {
    int16_t acc;
    uint8_t res[2];
    readRegs(addr, res, 2);

    acc = (res[0] << 6) | (res[1] >> 2);
    if (acc > UINT14_MAX/2)
        acc -= UINT14_MAX;

    return acc;
}

void MMA8451Q::fastRead(float * acc_arr) {
    uint8_t res[6];
    int16_t xt, yt, zt;
    
    readRegs(REG_OUT_X_MSB, res, 6);
    
    xt = (res[0]<<6)|(res[1]>>2);
    yt = (res[2]<<6)|(res[3]>>2);
    zt = (res[4]<<6)|(res[5]>>2);
    
    if (xt > UINT14_MAX/2)
        xt -= UINT14_MAX;
    if (yt > UINT14_MAX/2)
        yt -= UINT14_MAX;
    if (zt > UINT14_MAX/2)
        zt -= UINT14_MAX;
        
    acc_arr[0] = float(xt/4096.0);
    acc_arr[1] = float(yt/4096.0);
    acc_arr[2] = float(zt/4096.0);
}


void MMA8451Q::readRegs(int addr, uint8_t * data, int len) {
    char t[1] = {addr};
    m_i2c.write(m_addr, t, 1, true);
    m_i2c.read(m_addr, (char *)data, len);
}

void MMA8451Q::writeRegs(uint8_t * data, int len) {
    m_i2c.write(m_addr, (char *)data, len);
}