#include "mbed.h"
#define PI 3.1415926 

AnalogOut aout(PTE30);

//[f1(t)*sin(t) + f2(t)]
//f1(t) amplitude
//f2(t) x translation
//t our steps

int hills(48), oneHill(40); //number of hills in signature, number of steps in one hill
int hold(5); //number of milliseconds that are going to hold the signal
float ampl, transl;

void amplRefresh(int t)
{
    if(t < 2 * oneHill || (t >= 12 * oneHill && t < 14 * oneHill) || ( t >= 24 * oneHill && t < 26 * oneHill) || ( t >= 36 * oneHill && t < 38 * oneHill))
    ampl = 0.1;
    else if (t >= 2 * oneHill && t < 5 * oneHill)
     {
    if ((t + oneHill/2) % oneHill == 0) ampl *= 3;
     }
    else if ( t >= 5 * oneHill && t < 9 * oneHill)
    ampl = 1;
    else if ( t >= 9*oneHill && t < 12 * oneHill)
    {
    if ((t + oneHill/2) % oneHill == 0) ampl /= 3.;
    }
    else if ( t >= 14 * oneHill && t < 18 * oneHill)
    ampl = 0.7;
    else if ( t >= 18 * oneHill && t < 20 * oneHill)
    ampl = 0.35;
    else if ( t >= 20 * oneHill && t < 24 * oneHill)
    ampl = 1;
    else if ( t >= 26 * oneHill && t < 28 * oneHill)
    ampl = 1;
    else if ( t >= 28 * oneHill && t < 30 * oneHill)
    ampl = 0.8;
    else if ( t >= 30 * oneHill && t < 32 * oneHill)
    ampl = 1;
    else if ( t >= 32 * oneHill && t < 34 * oneHill)
    ampl = 0.8;
    else if ( t >= 34 * oneHill && t < 36 * oneHill)
    ampl = 1;
    else if ( t >= 38 * oneHill && t < 42 * oneHill)
    ampl = 0.5;
    else if ( t >= 42 * oneHill && t < 44 * oneHill)
    ampl = 0.4;
    else if ( t >= 44 * oneHill && t < 48 * oneHill)
    ampl = 1;  
}

float transRefresh(int t)
{
    
    if(t < 2 * oneHill || (t >= 12 * oneHill && t < 14 * oneHill) || ( t >= 24 * oneHill && t < 26 * oneHill) || ( t >= 36 * oneHill && t < 38 * oneHill))
    transl = 1;
    else if ( t >= 5 * oneHill && t < 9 * oneHill)
    transl = 0.7;
    else if ( t >= 9 * oneHill && t < 12 * oneHill)
    transl = 0.5;
    else if ( t >= 14 * oneHill && t < 18 * oneHill)
    {
    if( t == 14) transl = 0.7;
        else if ( (t + oneHill/2) % oneHill == 0 ) 
        transl -= 0.05;
    }
    else if ( t >= 18 * oneHill && t < 20 * oneHill)
    transl = 0.5;
    else if ( t >= 20 * oneHill && t < 24 * oneHill)
    transl = 0.7;
    else if ( t >= 26 * oneHill && t < 28 * oneHill)
    transl = 0.7;
    else if ( t >= 28 * oneHill && t < 30 * oneHill)
    {
    if( t == 28 )
        transl = 0.8;
        else if ( (t + oneHill/2) % oneHill == 0 )
        transl -= 0.05;
    }
    else if ( t >= 30 * oneHill && t < 32 * oneHill)
    transl = 0.7;
    else if ( t >= 32 * oneHill && t < 34 * oneHill)
      {
    if( t == 32 )
        transl = 0.8;
        else if ( (t + oneHill/2) % oneHill == 0 )
        transl -= 0.05;
    }
    else if ( t >= 34 * oneHill && t < 36 * oneHill)
    transl = 0.7;
    else if ( t >= 38 * oneHill && t < 42 * oneHill)
     {
    if( t == 38 )
        transl = 0.7;
        else if ( (t + oneHill/2) % oneHill == 0 )
        transl -= 0.05;
    }
    else if ( t >= 42 * oneHill && t < 44 * oneHill)
    transl = 0.5;
    else if ( t >= 44 * oneHill && t < 48 * oneHill)
     {
    if( t == 44 )
        transl = 0.2;
        else if ( (t + oneHill/2) % oneHill == 0 )
        transl += 0.05;
    } 
}

void writeLetter(int step){
   
    amplRefresh(step);
    transRefresh(step);
    aout = sin(PI / oneHill * step)*ampl/3.3 + transl;
    wait_us(hold);
}


int main() {
    for(int t = 0;;t++)
    {
    t %= hills * oneHill;
        writeLetter(t);
    }
}