#include "mbed.h"
#include "N5110.h"
#include <string>

DigitalOut enable(dp14);
N5110 displej(dp4,dp24,dp23,dp25,dp2,dp6,dp18);
Serial pc(USBTX, USBRX);

#define DELETE_CHAR '2'
#define BACKSPACE_CHAR '3'
#define ENTER_CHAR '1'
#define ROW_NUM 5
#define xPomak 1
#define yPomak 1
 
string text = "";
string prevText = "";
 
void ispisiText() {
    displej.clear();
    displej.setXYAddress(0, 0);
    int x = 0, y = 0;
    
    for(int i = 0; i < text.length(); i++) {
        if(text[i] == ENTER_CHAR)
            displej.setXYAddress(0, (y+yPomak) % ROW_NUM);
        else {
            displej.printChar(text[i]);
            x += xPomak;
        }
    }
 
  displej.refresh();
}
 
int main() {
    enable = 1;
    displej.init();
    displej.setXYAddress(0, 0);
    char znak;
    
    while(true) {
        prevText = text;
        if(pc.readable()) {
            znak = pc.getc();
            if(znak == DELETE_CHAR)
                text = "";
            else if(znak == BACKSPACE_CHAR)
                text = text.substr(0, text.length() - 1);
            else
                text.push_back(znak); 
        }   
        
        ispisiText();
    }
 
    return 0; 
}