#include "mbed.h"

int brojevi[10] = {0x40, 0x79, 0x24, 0x30, 0x19, 0x12, 0x02, 0x78, 0x00, 0x10};
BusOut segmenti(dp26, dp27, dp5, dp6, dp28, dp4, dp18);
BusOut pcdctc(dp23, dp24, dp25);
DigitalOut enable(dp14), tacka(dp17);
InterruptIn t1(dp1), t2(dp2);
Timer timer1, timer2;
Ticker stoperica;
int cifre_p[3] = {6,5,3};
float vrijednost = 0;

bool stop = true;
void StartStop() {
    if(timer1.read_ms() > 200) {
        stop = !stop;
        timer1.reset();
        }
 }
 
 void Restart() {
     if(timer2.read_ms() > 200) {
         stop = true;
         vrijednost = 0;
         timer2.reset();
    }
}

void Enable(int broj) {
    if(broj >= 0 && broj <= 9) segmenti = brojevi[broj];
    else segmenti = 0x7f;
}

void PrikaziCifru(int cifra, int broj) {
    Enable(broj);
    if(cifra == 1) tacka = 0;
    else tacka = 1;
    pcdctc = cifre_p[cifra];    
}

int i = 0;
void PrikaziVrijednost() {
    tacka = 1;
    pcdctc = 7;
    
    int prva, druga, treca;
    prva = int(vrijednost)/10;
    druga = int(vrijednost)%10;
    treca = int(vrijednost*10)%10;
    
    int niz_cifara[3] = {prva, druga, treca};
    PrikaziCifru(i, niz_cifara[i]);
    
    if(vrijednost <= 99.9 && !stop) { vrijednost += 0.005; if(vrijednost == 99.9) vrijednost = 0; }
    
    i = (i+1) % 3;
}

int main() {
     enable = 1;
    segmenti=0;
    pcdctc=0;
    wait(1);
    pcdctc=7;
    wait(1);
    pcdctc=0;
    wait(1);
   
    
    
   
    stoperica.attach(&PrikaziVrijednost, 0.005);
    timer1.start();
    timer2.start();
    t1.rise(&StartStop);
    t2.rise(&Restart); 
    while(1){}
   
}
