#include "mbed.h"
#include <queue>

using namespace std;

BusOut segments(dp2, dp1, dp28, dp6, dp5, dp27, dp26);
BusOut digit(dp23, dp24, dp25);
DigitalOut decimal_point(dp4);
AnalogIn voltage(dp9);


int predefined_segments[10] = {0x01, 0x4f, 0x12, 0x06, 0x4c, 0x24, 0x20, 0x0f, 0x00, 0x04};

void display(float tmp)
{
    int digits[3] = {(int)(tmp / 100) % 10, (int)(tmp / 10) % 10, (int)(tmp) % 10};
    for(int i = 1; i <= 4; i = i * 2) {
        segments = predefined_segments[digits[i / 2]];
        digit = ~i;
        decimal_point = (i == 2) ? 0 : 1;
        wait_ms(1);
    }
}

int main()
{
    queue<double> aritmeticke;
    double suma = 0;
    double srednjaVrijednost;
    for (int i = 0; i < 100; i++)
        {aritmeticke.push(voltage * 3.3 * 1000);
        suma += aritmeticke.back();}
    srednjaVrijednost = suma / 100;
    while(1) {
        suma -= aritmeticke.front();
        aritmeticke.pop();
        aritmeticke.push(voltage * 3.3 * 1000);
        suma += aritmeticke.back();
        srednjaVrijednost = suma / 100;
        display(srednjaVrijednost);
    }
}
