#include "mbed.h"
#include "nRF24L01P.h"
#include "string"
#define TRANSFER_SIZE   2

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTA13);     // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);


char nick [20];
int brojac=0;
int i=0;
int main()
{

    int vel=0,j=0;
    int txDataCnt = 0;
    int rxDataCnt = 0;
    char txData[TRANSFER_SIZE], rxData[20];
    string str="";

    pc.printf( "Dobrodosli na Wi-Fi chat\n \n" );
    pc.printf( "Unesite vas nick: " );
    pc.scanf("%s",&nick);
    pc.printf("Vas nick je ...'%s'...\n", nick);
    for (j=0; j<20; j++) {
        if(nick[j]=='\0') {
    
            break;
        }
        brojac++;
    }
     nick[brojac++]=':';
     nick[brojac++]=' ';
        
    strcat(nick,": ");
    pc.printf("Cekanje na drugog korisnik ...\n");

    my_nrf24l01p.powerUp();
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
     pc.printf("\n");
      pc.printf("%s",nick);


    while (1) {

        // If we've received anything over the host serial link...
        if ( pc.readable() ) {

            if(i==0) {
                for (j=0; j<brojac; j++) {
                    txData[txDataCnt++] = nick[j];
                    
                    // If the transmit buffer is full
                    if ( txDataCnt >= sizeof( txData ) ) {

                        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );

                        txDataCnt = 0;
                    }
                }


            }


            txData[txDataCnt++] = pc.getc();

            // If the transmit buffer is full
            if ( txDataCnt >= sizeof( txData ) ) {

                // Send the transmitbuffer via the nRF24L01+
                my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );

                txDataCnt = 0;
            }
            i=1;
            // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
            myled1 = !myled1;
        }

        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {
            i=0;
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );

            str += rxData;
            vel += rxDataCnt;
            if(str[vel-1] == '.') {
                   

                vel--;
                pc.printf("\n");
                
                // Display the receive buffer contents via the host serial link
                for ( int i = 0; vel > 0; vel--, i++ ) {

                    pc.putc( str[i] );
                }
                pc.printf("\n");
                vel = 0;
                str ="";

                rxDataCnt = 0;
            }
          
            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            myled2 = !myled2;
        }
    }
}
