#include "motor.h"
#include "mbed.h"
 
int brzinaMotora; // Steper speed
 
motor::motor(PinName A0, PinName A1, PinName A2, PinName A3) : _A0(A0), _A1(A1), _A2(A2), _A3(A3) { // Defenition of motor pins
    _A0=0; _A1=0; _A2=0; _A3=0;
}
 
void motor::postaviPinove(int vr) {
        switch (vr) {
            case 0: { _A0=0; _A1=0; _A2=0; _A3=1; }
            break;
            case 1: { _A0=0; _A1=0; _A2=1; _A3=1; }
            break;
            case 2: { _A0=0; _A1=0; _A2=1; _A3=0; }
            break;
            case 3: { _A0=0; _A1=1; _A2=1; _A3=0; }
            break;
            case 4: { _A0=0; _A1=1; _A2=0; _A3=0; }
            break;
            case 5: { _A0=1; _A1=1; _A2=0; _A3=0; }
            break;
            case 6: { _A0=1; _A1=0; _A2=0; _A3=0; }
            break;
            case 7: { _A0=1; _A1=0; _A2=0; _A3=1; }
            break;
        }
        wait_us(brzinaMotora); // wait time defines the speed
    }
 
void motor::binarniBrojac(bool nazad) {
    if (nazad)
        for (int i = 7; i >= 0; i--)
            postaviPinove(i);
   
    if (!nazad)
        for (int i = 0; i <= 7; i++)
            postaviPinove(i);
}
 
void motor::nazad() { // rotate the motor 1 step anticlockwise
    binarniBrojac(true);
}
 
void motor::naprijed() { // rotate the motor 1 step clockwise
    binarniBrojac(false);
}
void motor::korak(float broj_koraka, int smjer, int brzina) {// steper function: number of steps, direction (0- right, 1- left), speed (default 1200)
    int count=0; // initalize step count
    brzinaMotora=brzina; //set motor speed
    if (smjer==0) // turn clockwise
        do {
            naprijed();
            count++;
        } while (count<broj_koraka); // turn number of steps applied
    else if (smjer==1)// turn anticlockwise
        do {
            nazad();
            count++;
        } while (count<broj_koraka);// turn number of steps applied
}