#include <stdio.h>
#include <stdlib.h>
#include "mbed.h"
#include "sMotor.h"

Serial pc(USBTX, USBRX);
sMotor motor (dp13, dp11, dp10, dp9);

int step_speed = 1200;
const int step = 512;
int rot = 0;
bool ukljucen = true;


int main()
{
    pc.printf("1 Postavljanje osovine ");
    pc.printf("\n2 Promjena smjera kretanja");
    pc.printf("\n3 Promjena brzine kretanja");
    pc.printf(" \n4 Start/stop \n");

    while(1) {
        
        char c;
        if(ukljucen) motor.step(step, rot, step_speed);
        wait(0.5);
        if(pc.readable()) {
            c = pc.getc();

            if(c == '1') {
                motor.step(step, rot, 0);
                int ugao(0);
                bool trigger = false;
                pc.printf("\nUnesite polozaj motora u stepenima [0 - 360] : ");
                pc.scanf("%d", &ugao);
                if(ugao < 0 || ugao > 360) {
                    pc.printf("Ugao nije ispravno unesen.\n");
                    trigger = true;
                }
                if(ugao != 0 && !trigger) {
                    double n = 360.0 / ugao;
                    if(ukljucen)
                        motor.step((int)(step / n), rot, step_speed);    
                }
                wait(1);
            }

            if(c == '2') {
                rot = 1 - rot;
                if(ukljucen)
                    motor.step(step, rot, step_speed);
            }

            if(c == '3') {
                pc.printf("\nUnesite brzinu : ");
                pc.scanf("%d", &step_speed);
                if(ukljucen)
                    motor.step(step, rot, step_speed);
            }

            if(c == '4') {
                ukljucen = !ukljucen;
                if(ukljucen) motor.step(step, rot, step_speed);
            }

        }

    }
}