#ifndef E_Motor_H
#define E_Motor_H
#include "mbed.h"
/* CopyRight (C) 2014, by Enil Pajić */
class Enil4StepMotor
    {
        int eD, eS, eINS[8];
        bool eCW, eAtt;
        BusOut eIN;
        Ticker T;
        int Normalize (int S, bool P = true) {if (S < 0) S = -S; S %= 360; double X = S; if (P) X = (512. / 360.) * double (S); return X;}
        void Rotate (bool CW) {for (int a = CW ? 7 : 0; CW ? a >= 0 : a < 8; CW ? --a : ++a) eIN = eINS[a], wait_us (eS);/*wait_ms (eS / 10.);*/}
        void RotateHelper () {Rotate (eCW);}
    public:
        Enil4StepMotor (PinName IN1, PinName IN2, PinName IN3, PinName IN4, int MSpeed = 500) : 
            eD (0), eS(500), eCW (true), eAtt (false), eIN (IN1, IN2, IN3, IN4)
            {
                int X[8] = {0x1, 0x3, 0x2, 0x6, 0x4, 0xC, 0x8, 0x9};
                for (int a = 0; a < 8; ++a) eINS[a] = X[a];
                Speed (MSpeed);
            }
        bool ClockWiseDirection () const {return eCW;}
        bool &ClockWiseDirection () {return eCW;}
        int Degrees () const {return eD;}
        int Speed () const {return eS;}
        void Speed (int S) {if (S <= 0) S = 1; if (S > 999) S = 999; eS = 1000 - S;}
        void RotateRelative (int Step, bool ClockWise)
            {
                eD = Normalize (Step, false);
                Step = Normalize (Step);
                while (Step--) Rotate (ClockWise);
            }
        void RotateAbsolute (int Step)
            {
                bool P = eCW;   
                Step = Normalize (Step, false);
                int X = Step - eD; if (X < 0) eCW = !eCW, X = -X;
                RotateRelative (X, eCW);
                eCW = P;
            }
        void Start () {if (!eAtt) eAtt = true, T.attach (this, &Enil4StepMotor::RotateHelper, 0.0001);} //Regulirati 1-999 (ms|us). 0.00001, 0.005, 0.01
        void Stop () {if (eAtt) eAtt = false, T.detach();}
        bool Running () const {return eAtt;}
    };
#endif  //E_Motor_H
