#include "mbed.h"
#include "MMA8451Q.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
Serial pc(USBTX, USBRX);

int main(void) {
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    float x, y, z;

    while(1) {
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        pc.printf("x: %f, y: %f, z: %f\n", x, y, z);
        wait(1);
    }
}
