#include "mbed.h"
#include "TSISensor.h"
#include "ctype.h"

Serial pc(USBTX, USBRX);
TSISensor tsi;
Ticker tiker;
PwmOut led[3] = {LED1, LED2, LED3};

void pisi(){
    int postotak = tsi.readPercentage() * 100;
pc.printf("TSI: %d\n",postotak);
    }

void funkcija(char c)
{
    char c1=pc.getc();
    char c2=pc.getc();
    double osvjetljenje = 0;
    if(!isdigit(c1) || !isdigit(c2)) return;
    osvjetljenje=(c1-'0')*10;
    osvjetljenje=osvjetljenje + (c2 - '0');
    for(int i=0;i<3;i++) led[i]=1.0;
    if(c=='R') led[0]=1.0 - osvjetljenje/100;
    else if(c=='G') led[1]=1.0 - osvjetljenje/100;
    else if(c=='B') led[2]=1.0 - osvjetljenje/100;
    else return;
}

void citaj()
{
    if(!pc.readable()) return;
    char c = pc.getc();
    if(c=='R' || c=='B' || c=='G') funkcija(c);
    else if(c=='P') tiker.attach(pisi,1.0);
    else if(c=='Z') tiker.detach();
    else return;  
}


int main() {
    for(int i=0;i<3;i++)
    {
        led[i]=1.0;
    }
    pc.attach(citaj);
    
    
    while(1);
}
