#include "mbed.h"
#include <TSISensor.h>
//By EnilP, 04.05.2014, ETF PAI
Serial PC (USBTX, USBRX);
Ticker T, TTSI;
TSISensor TSI;
PwmOut LEDR (LED1), LEDG (LED2), LEDB (LED3);
int Duzina (const char *S) {int C = 0; while (*S++) ++C; return C;}
bool IsNum (const char C) {return C >= 48 && C <= 57; }
bool BuffOK (const char *C) 
    {return ((*C == 'R' || *C == 'G' || *C == 'B') && IsNum (C[1]) && IsNum (C[2])); }
void ReadTSI ()
    {
        if (PC.writeable()) //Provjeriti?
            PC.printf ("TSI Vrijednost: %.0f%%\n", TSI.readPercentage() * 100.f);
    }
void DoIt ()
    {
        if (!PC.readable()) return; //Provjeriti?  
        static char Buff[50];
        
        char C = PC.getc();
        while (C != 'R' && C != 'G' && C != 'B' && C != 'P' && C != 'Z') C = PC.getc();
        Buff [0] = C;
        if (C != 'P' && C != 'Z')
        {
            Buff [1] = PC.getc();
            Buff [2] = PC.getc();
            Buff[3] = '\0';
        }
        else
            Buff[1] = '\0';// (Buff, 4); //Provjeriti, ...,4?
        int D = Duzina (Buff);
        if (D > 3) return;
        else if (D == 3 && BuffOK (Buff))
            {
                double Val = double((Buff[1] - 48) * 10 + Buff[2] - 48) / 100.;
                Val = 1. - Val;
                char C = Buff[0];
                if (C == 'R') LEDR = Val, LEDG = LEDB = 1.0;
                else if (C == 'G') LEDG = Val, LEDR = LEDB = 1.0;
                else LEDB = Val, LEDR = LEDG = 1.0;
            }
        else if (D == 1 && (Buff[0] == 'P' || Buff[0] == 'Z'))
            {
                if (Buff[0] == 'P') TTSI.attach (&ReadTSI, 1.0);
                else TTSI.detach();
            }
        else return;
            
    }
int main() //Novi tim
    {
        //TTSI.attach (&ReadTSI, 0.01);
        T.attach (&DoIt, 0.05); //Regulirati 0.2, 0.1, 0.05, 0.01, 0.001
        while (7);
    }