#include "mbed.h"
#include "N5110.h"

//Deklaracija LCD objekta
//N5110 lcd(VCC,SCE,RST,D/C,MOSI,SCLK,LED)
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);
 
//Digitalni izlaz za deaktivaciju LED buffera
DigitalOut enable(dp14);

//Analogni ulazi sa dzojstika
AnalogIn    VRx(dp11);
AnalogIn    VRy(dp10);
//Taster sa dzojstika
DigitalIn   SW(dp9);

void krug(int a,int b) {
    if(a<3 || a>80 || b<3 || b>44) return;
    lcd.clear();
    lcd.refresh();
    lcd.setXYAddress(0,0);
    
    lcd.setPixel(a,b); //nije potrebno
    
    lcd.setPixel(a-3,b);
    lcd.setPixel(a-3,b+1);
    lcd.setPixel(a-3,b-1);
    lcd.setPixel(a+3,b-1);
    lcd.setPixel(a+3,b);
    lcd.setPixel(a+3,b+1);
    lcd.setPixel(a-2,b+2);                                                
      lcd.setPixel(a-2,b-2);    
       lcd.setPixel(a+2,b+2);    
        lcd.setPixel(a+2,b-2);    
        lcd.setPixel(a-1,b+3);    
        lcd.setPixel(a,b+3);   
        lcd.setPixel(a+1,b+3);   
        lcd.setPixel(a-1,b-3);   
        lcd.setPixel(a,b-3); 
        lcd.setPixel(a+1,b-3);     
          
    
        lcd.refresh();
        
        
}
             
                                        


int main() {
    enable=1;
    //Aktivacija pull-up otpornika
    SW.mode(PullUp);
    int x=42, y=24;
     lcd.init();
    
     krug(x,y);    

    while(1) {
      if (VRx<1.0/3.0) 
     {
         x=x-1;
    
     krug(x,y); 
    }
     else if (VRx<2.0/3.0) 
    {
    krug(x,y); 
    }
    else 
    {x=x+1;
    krug(x,y); }
    wait(0.05);
    
    if (VRy<1.0/3.0) 
     {
      y=y-1;
      krug(x,y); 
 
    }
     else if (VRy<2.0/3.0) 
    {
    krug(x,y); 
  
    }  
    else    
    {
     y=y+1;
     krug(x,y); 
    }
       wait(0.05); 
    }
    
    if(SW==1) wait(5);
    
    
     
     
    
}
