#include "mbed.h"
#include "N5110.h"
//By Enil Pajić, 27.04.2014, ETF PAI
DigitalOut ENBL (dp14);
N5110 DISP (dp4, dp24, dp23, dp25, dp2, dp6, dp18);
InterruptIn BTN (dp9);
AnalogIn X (dp11), Y (dp10); //InterruptIn?
Ticker Refresh, Wait;
Timer Dbnc;
int eX = 2, eY = 2, pX = 0, pY = 0;
int Xs[12] = {1, 0, -1, -2, -2, -2, -1, 0, 1, 2, 2, 2};
int Ys[12] = {2, 2, 2, 1, 0, -1, -2, -2, -2, -1, 0, 1};
bool DrawIt = true;
void Draw (int x, int y)
    {
        if (x < 2 || x > 81) return; // [0, 84) 
        if (y < 2 || y > 45) return; // [0, 48) // y > 38 Or y > 30 /(-1) 
       // if (x == pX && y == pY) return; //Da ne cistimo, refreshujemo i crtamo krug ako je na istim koordinatama
        pX = x, pY = y;
        DISP.clear();
        DISP.refresh();
        DISP.setXYAddress (0, 0);
        for (int a = 0; a < 12; ++a)
            DISP.setPixel (x + Xs[a], y + Ys[a]);
        DISP.refresh();        
    }
double Zaokruzi (double broj) //Na 2 dec
    {return double(int(broj * 100.0 + .5) / 100.0); }
void DajCifre (double N, int &Cio, int &PrvaDec, int &DrugaDec) //broj u #.## formatu
    {
        double dec = (N - (int)N);
        dec = Zaokruzi(dec * 100.);
        DrugaDec = (int)dec % 10;
        PrvaDec = ((int)dec / 10) % 10;
        Cio = (int)N;
    }
void DoIt ()
    {
        double vx = X, vy = Y;
        if (vx <= .2) eX = (eX <= 2 ? 2 : eX - 2);
        else if (vx <= .4) eX = (eX <= 2 ? 2 : eX - 1);
        else if (vx <= .6);
        else if (vx <= .8) eX = (eX >= 81  ? 81 : eX + 1);
        else eX = (eX >= 81  ? 81 : eX + 2);                //Malo muzikanja :P ako jako povucemo, brze se pomjera
        if (vy <= .2) eY = (eY <= 2 ? 2 : eY - 2);          //Ako slabije povucemo, sporije se pomjera
        else if (vy <= .4) eY = (eY <= 2 ? 2 : eY - 1);
        else if (vy <= .6);
        else if (vy <= .8) eY = (eY >= 45  ? 45 : eY + 1);
        else eY = (eY >= 45  ? 45 : eY + 2);
        Draw (eX, eY);
        if (!DrawIt) return;   
        int xCio = 0, xPD = 0, xDD = 0, yCio = 0, yPD = 0, yDD = 0;
        DajCifre (vx, xCio, xPD, xDD);
        DajCifre (vy, yCio, yPD, yDD);
        char ch[13] = "(0.00, 0.00)";
        ch[1] = 48 + xCio; ch[3] = 48 + xPD; ch[4] = 48 + xDD;
        ch[7] = 48 + yCio; ch[9] = 48 + yPD; ch[10] = 48 + yDD;
        char ph [9] = "(00, 00)";
        ph[1] = 48 + eX / 10; ph[2] = 48 + eX % 10;
        ph[5] = 48 + eY / 10; ph[6] = 48 + eY % 10;
        DISP.printString (ch, 0, 5);
        DISP.printString (ph, 0, 4); // DISP.printString (ph, 0, 4);
    }
void Enable() {DrawIt = true; Wait.detach();} //Provjeriti !?
void Pressed()
    {
        if (Dbnc.read() > .2)
            {
                if (!DrawIt) return;
                DrawIt = false;
                Wait.attach (&Enable, 5.0);
            }
        Dbnc.reset();
    }
int main()
    {
        ENBL = 1;
        BTN.mode (PullUp);
        Dbnc.start();
        BTN.rise (&Pressed);
        DISP.init();
        Refresh.attach (&DoIt, 0.05); //Regulirati: 0.2, 0.1, 0.05, 0.01
        while(1); //While kakvog profesor želi :P
    }