#include "mbed.h"
 
using namespace std;
 
BusOut segments(dp26, dp27, dp5, dp6, dp28, dp4, dp18);
BusOut digit(dp23, dp24, dp25);
DigitalOut point(dp17);

InterruptIn taster1(dp1);
InterruptIn taster2(dp2);
 
Timer debounse;
Timer count;
Timer lazni;
Ticker osvjezi;

bool pom = false;

int codes[10] = {0x40,0x79,0x24,0x30,0x19,0x12,0x02,0x078,0x0,0x10};
 
 
 
void display() {
    float time = count.read_ms() / 1000.;
    
    int numbers[3] = { (int)(time / 10.) % 10, (int)(time) % 10, 
                            (int)(time * 10.) % 10 };
 
    segments = codes[ numbers[2]];
    digit = 3;
    
    
    lazni.reset();
    lazni.start();
    while(lazni.read_ms() < 2);
    
    
    digit = 7;
        
        segments = codes[ numbers[1]];
    digit = 5;
    
    point = 0;
    lazni.reset();
    lazni.start();
    while(lazni.read_ms() < 2);
    
    digit = 7;    
 
 segments = codes[ numbers[0]];
    digit = 6;
    
    point = 1;
        
    lazni.reset();
    lazni.start();
    while(lazni.read_ms() < 2);
    
    digit = 7;
        
 
    segments = 7;
    point = 1;
}
 
void pocetak()
{
  if(debounse.read_ms() >= 200)
  {
      if(!pom)
      { count.start();
        pom = true;
        }
      else 
      {count.stop();
      pom = false;
      }
        debounse.reset();
  }
} 

 
void reset()
{
    count.reset();    
    count.stop();
    pom = false;
}

int main() {
    digit=0;
    segments=0;
    wait(1);
    digit=7;
    wait(1);
    digit=0;
    wait(1);
    
    debounse.start();
    taster1.rise(&pocetak);
    
    taster2.rise(&reset);
    
    osvjezi.attach_us(&display, 10000);
    
    while(true) {
        
    }
    
    
}
       