#include "mbed.h"

DigitalOut cifre[3] = {dp23, dp24, dp25};
BusOut disp(dp4, dp2, dp1, dp28, dp6, dp5, dp27, dp26);
//Novo za LV4
AnalogIn ulaz(dp9);
//end

int _7sd(char znak, bool tocka = false)
{
    //za sljedeci raspored: a b c d e f g dp
    //a to su dp26 dp27 dp5 dp6 dp28 dp1 dp2 dp4
    int t = !tocka;
    switch(znak)
    {
        case 'N':
            return 0xfe | t;
        case '0':
            return 0x02 | t;
        case '1':
            return 0x9e | t;
        case '2':
            return 0x24 | t;
        case '3':
            return 0x0c | t;
        case '4':
            return 0x98 | t;
        case '5':
            return 0x48 | t;
        case '6':
            return 0x40 | t;
        case '7':
            return 0x1a | t;
        case '8':
            return 0x00 | t;
        case '9':
            return 0x08 | t;
        case 'a': case 'A':
            return 0x10 | t;
        case 'b': case 'B':
            return 0xc0 | t;
        case 'c': case 'C':
            return 0x62 | t;
        case 'd': case 'D':
            return 0x84 | t;
        case 'e': case 'E':
            return 0x60 | t;
        case 'f': case 'F':
            return 0x70 | t;
        case '*':
            return 0x90 | t;
        case '#':
            return 0x6c | t;
    }
}


void ispisi(int broj){
    int znakovi[3] = {(broj%1000)/100, (broj%100)/10, broj%10};
    for(int i = 0; i < 3; i++){
        cifre[i] = 0;
        disp = _7sd(znakovi[i] + '0', i == 0); //tacku na prvom
        wait(0.0025);  //ovo mijenjati da se ustima bolje svjetlo
        cifre[i] = 1;
    }
}

int main() {
    //char c, c1;
    int counter = 0;
    float pot, suma;
    wait(0.05);
    char niz[3] = {'8', '3','9'};
    
    pot = ulaz;
    while(1){
            if(counter == 50){
                pot = suma/50.f;
                counter = 0;
                suma = 0;
            }
            ispisi(pot * 330.f);
            suma += ulaz;
            counter++;
    }

}