#include "mbed.h"
#include "time.h"

DigitalOut cifre[3] = {dp23, dp24, dp25};

BusOut disp(dp4, dp2, dp1, dp28, dp6, dp5, dp27, dp26);

int _7sd(char znak, bool tocka = false)
{
    //za sljedeci raspored: a b c d e f g dp
    //a to su dp26 dp27 dp5 dp6 dp28 dp1 dp2 dp4
    int t = !tocka;
    switch(znak)
    {
        case '0':
            return 0x02 | t;
        case '1':
            return 0x9e | t;
        case '2':
            return 0x24 | t;
        case '3':
            return 0x0c | t;
        case '4':
            return 0x98 | t;
        case '5':
            return 0x48 | t;
        case '6':
            return 0x40 | t;
        case '7':
            return 0x1a | t;
        case '8':
            return 0x00 | t;
        case '9':
            return 0x08 | t;
        case 'a': case 'A':
            return 0x10 | t;
        case 'b': case 'B':
            return 0xc0 | t;
        case 'c': case 'C':
            return 0x62 | t;
        case 'd': case 'D':
            return 0x84 | t;
        case 'e': case 'E':
            return 0x60 | t;
        case 'f': case 'F':
            return 0x70 | t;
        case '*':
            return 0x90 | t;
        case '#':
            return 0x6c | t;
    }
}

class Stoperica
{
    clock_t poc, kraj;
    bool running;
public:
    Stoperica(){running = true; poc = clock(); }
    
    void start(){ running = true;poc = clock();}
    void stop(){ kraj = clock();}
    bool Running(){return running;}
    float ocitaj(){stop(); return (kraj - poc)*1000./CLOCKS_PER_SEC;}
private:

};

void ispisi(float vrijeme){
    int broj = vrijeme;
    int c[3] = { (broj%1000)/100, (broj%100)/10, broj%10 };
    
    for(int i = 0; i < 3; i++){
        cifre[i] = 0;
        disp = _7sd(c[i] + '0', i==1);
        wait(0.0025);  
        cifre[i] = 1;
         
    }
}
int main() {
    wait(2);
    clock_t poc, tren;
    poc = clock();
    
    tren = clock();
    while(1){
        if((tren - poc)*10/CLOCKS_PER_SEC < 123) tren = clock();
        
        ispisi((tren - poc)*10/CLOCKS_PER_SEC);
        wait(0.02);
    }
    
}
