#include "mbed.h"
 


DigitalOut red1(dp16), red2(dp15), red3(dp17), red4(dp18);
DigitalIn kol1(dp9), kol2(dp10), kol3(dp11), kol4(dp13);
 
DigitalOut cifre[3] = {dp23, dp24, dp25};
BusOut disp(dp4, dp2, dp1, dp28, dp6, dp5, dp27, dp26);


int _7sd(char znak, bool tocka = false)
{
    //za sljedeci raspored: a b c d e f g dp
    //a to su dp26 dp27 dp5 dp6 dp28 dp1 dp2 dp4
    int t = !tocka;
    switch(znak)
    {
        case 'N':
            return 0xfe | t;
        case '0':
            return 0x02 | t;
        case '1':
            return 0x9e | t;
        case '2':
            return 0x24 | t;
        case '3':
            return 0x0c | t;
        case '4':
            return 0x98 | t;
        case '5':
            return 0x48 | t;
        case '6':
            return 0x40 | t;
        case '7':
            return 0x1a | t;
        case '8':
            return 0x00 | t;
        case '9':
            return 0x08 | t;
        case 'a': case 'A':
            return 0x10 | t;
        case 'b': case 'B':
            return 0xc0 | t;
        case 'c': case 'C':
            return 0x62 | t;
        case 'd': case 'D':
            return 0x84 | t;
        case 'e': case 'E':
            return 0x60 | t;
        case 'f': case 'F':
            return 0x70 | t;
        case '*':
            return 0x90 | t;
        case '#':
            return 0x6c | t;
    }
}

char ocitajtast()
{
    red1 = 0; red2 = 0; red3 = 0; red4 = 0;

    
    red1 = 1;
    if( kol1 == 1) return '1';
    
    if( kol2 == 1) return '2';
   
    if( kol3 == 1) return '3';
    
    if(kol4 == 1) return 'A';
    
    red1 = 0;
    
    red2 = 1;
    if( kol1 == 1) return '4';
    if( kol2 == 1) return '5';
    if( kol3 == 1) return '6';
    if(kol4 == 1) return 'B';
    red2 = 0;
    
    red3 = 1;
    if( kol1 == 1) return '7';
    if( kol2 == 1) return '8';
    if( kol3 == 1) return '9';
    if(kol4 == 1) return 'C';
    red3 = 0;
    
    red4 = 1;
    if( kol1 == 1) return '*';
    if( kol2 == 1) return '0';
    if( kol3 == 1) return '#';
    if(kol4 == 1) return 'D';
    red4 = 0;
 
    return 'N';
}

void ispisi(char znakovi[] ){
    
    for(int i = 0; i < 3; i++){
        cifre[i] = 0;
        disp = _7sd(znakovi[i]);
        wait(0.0025);  
        cifre[i] = 1;
         
    }
}

char niz[3];

void dodaj(char c){
    if(c == 'C'){
        for(int i = 0; i < 3; i++)
            niz[i] = 'N';   
    } else {
        niz[0] = niz[1];
        niz[1] = niz[2];
        niz[2] = c;
    }
}

int main() {
    char c;
    
    niz[0] = '8';
    niz[1] = '8';
    niz[2] = '8';
    
    clock_t poc = clock();
    while(1){
        ispisi(niz);
        if(((clock() - poc)/CLOCKS_PER_SEC) > 2) break;
    }
    
    niz[2] = 'b';
    niz[2] = 'c';
    while(1){
           
           for(int i = 0; ; i++)
           {
                ispisi(niz);
                c = ocitajtast();
                if( c == 'N'){
                    break;   
                }    
                
                wait(0.12);
                dodaj(c);   
                
                
            }
            
           
    }
    
}
