#include "mbed.h"
//by Enil Pajić@ETF, 16.03.2014
BusOut bLEDS (dp23, dp24, dp25, dp26, dp27, dp5, dp6, dp28); //Led 0, 1, 2, 3, 4, 5, 6, 7
DigitalOut dLEDS[8] = {dp23, dp24, dp25, dp26, dp27, dp5, dp6, dp28};

//BusOut bTASTER = (dp1, dp2); //dp1 = Taster1; dp2 = Taster2
//DigitalOut dTASTER [2] = {dp1, dp2};

DigitalOut ENBL = dp14;

BusIn bKOL(dp9, dp10, dp11, dp13);
//DigitalIn dKOL[4] = {dp9, dp10, dp11, dp13};

BusOut bRED(dp16, dp15, dp17, dp18);
//DigitalOut dRED[4] = {dp16, dp14, dp17, dp18};

BusOut bDISP (dp23, dp24, dp25);
BusOut dDISP[3] = {dp23, dp24, dp25};

BusOut bDIGIT(dp2, dp1, dp28, dp6, dp5, dp27, dp26); // (dp26, dp27, dp5, dp6, dp28, dp1, dp2);
DigitalOut dDIGIT[7] = {dp2, dp1, dp28, dp6, dp5, dp27, dp26};
DigitalOut DECP (dp4);
DigitalOut eA(dp26), eB(dp27), eC(dp5), eD(dp6), eE(dp28), eF(dp1), eG(dp2);

typedef unsigned long T;
template <T N>
class eBIN
    {
    public: 
        enum {VAL = (N % 8) + (eBIN<N/8>::VAL << 1)};
    };
template <>
class eBIN<0>
    {
    public:
        enum {VAL = 0};
    };
#define BIN(N) eBIN<0##N>::VAL

enum Keys {N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, A, B, C, D, Star, Hash, None = -1};
enum Diodes {D1 = 6, D2 = 5, D3 = 3};
void Display (Keys Key, Diodes Diode, bool DisplayPoint)
    {
        if (Key == None) return;
        bDISP = (int)Diode;
        DECP = DisplayPoint ? 0 : 1;
        switch (Key)
            {
                case N0:
                    bDIGIT = BIN(0000001); //1
                    break;
                case N1:
                    bDIGIT = BIN(1001111); //79
                    break;
                case N2:
                    bDIGIT = BIN(0010010); //18
                    break;
                case N3:
                    bDIGIT = BIN(0000110); //6
                    break;
                case N4:
                    bDIGIT = BIN(1001100); //76
                    break;
                case N5:
                    bDIGIT = BIN(0100100); //36
                    break;
                case N6:
                    bDIGIT = BIN(0100000); //32
                    break;
                case N7:
                    bDIGIT = BIN(0001111); //15
                    break;
                case N8:
                    bDIGIT = BIN(0000000); //0
                    break;
                case N9:
                    bDIGIT = BIN(0000100); //4
                    break;
                case A:
                    bDIGIT = BIN(0001000); //A //8
                    break;
                case B:
                    bDIGIT = BIN(1100000); //b //96
                    break;
                case C:
                    bDIGIT = BIN(1110010); //c //114
                    break;
                case D:
                    bDIGIT = BIN(0000010); //d //2
                    break;
                case Star:
                    //xD ovo je 'e' slovo. Za gornje 'o' slovo je 0011100, za 'u' je 1100011 a za donje 'o' je 1100010
                    bDIGIT = BIN(0010000); // 16 //za 'P' = 0011000
                    break;
                case Hash:
                    bDIGIT = BIN(1001000); //slovo H kao HASH :D //72
                    break;
                case None:
                    bDIGIT = BIN(1111111); //127
                    break;
            }
        
    } 
void DisplayKeys (Keys K1, Keys K2, Keys K3, unsigned int Point, int DelayMS = 10)
    {
        Display (K1, D1, Point == 1);
        if (K1 != None) wait_ms (DelayMS);
        Display (K2, D2, Point == 2);
        if (K2 != None) wait_ms (DelayMS);
        Display (K3, D3, Point == 3);
        if (K3 != None) wait_ms (DelayMS);
    }
char ReadKey ()
    {
        static const int Keys[4] =  {1, 2, 4, 8}; 
        static const char Chars[4][4] = {
                                            {'1', '2', '3', 'A'},
                                            {'4', '5', '6', 'B'},
                                            {'7', '8', '9', 'C'},
                                            {'*', '0', '#', 'D'}
                                        };
        for (int a = 0; a < 4; ++a)
            {
                bRED = Keys[a];
                for (int b = 0; b < 4; ++b)
                    if (bKOL == Keys[b])
                        return Chars [a][b];
            }
        return '-';
    }
void TrciDesno (float Time = 0.75)
    {
        for (int a = 0; a < 8; ++a)
            {
                bLEDS = 255; // = 0;
                dLEDS[a] = 0; // = 1;
                wait (Time);
            }
    }
void TrciLijevo (float Time = 0.75)
    {
        for (int a = 7; a > -1; --a)
            {
                bLEDS = 255; // = 0;
                dLEDS[a] = 0; // = 1;
                wait (Time);
            }
    }
int Main_Stoperica() //Main_Stoperica()
    {
        ENBL = 1;
        for (int a = 0; a < 32; ++a)
            DisplayKeys (N0, N0, N0, 2, 2);
        //wait (2.0);
        int ds = 1, sa = 0, ss = 0;
        int Delay = 2;
        bool Play = true;
        while (7)
            {
                DisplayKeys ((Keys)sa, (Keys)ss, (Keys)ds, 2, 2);
                if (Play)
                    {
                                                    if (++ds > 9) ss++, ds = 0;
                            if (ss > 9) sa++, ss = 0;
                            if (sa == 1 && ss == 2 && ds == 3) Play = false; 
                        for (int a = 0; a < 16; ++a)
                        {

                            DisplayKeys ((Keys)sa, (Keys)ss, (Keys)ds, 2, 2);   
                        }

                        //wait_ms (100 - 3 * Delay);
                    }               
            }
    }
int main() //Main_Calc()
    {
        ENBL = 1;
        const int Delay = 10;
        DisplayKeys (None, None, N0, 0, 1);
        int Digit = 0;
        char Key = '-';
        int kA = None, kB = None, kC = N0;
        bool Down = true;
        while (7)
            {
                Key = ReadKey();
                                    if (Key != '-' && !Down) Down = true;
                if (Key == '-') Down = false;
                if (Down && (Key >= '0' && Key <= '9'))
                    {
                                                if (Digit == 0) kC = (Keys)(Key - 48);
                        if (Digit == 1) kB = kC, kC = (Keys)(Key - 48);
                        if (Digit == 2) kA = kB, kB = kC, kC = (Keys)(Key - 48);
                        Digit++;

                    }
                if (Down && (Key == 'C')) kA = None, kB = None, kC = N0, Digit = 0;
                DisplayKeys ((Keys)kA, (Keys)kB, (Keys)kC, 0, Delay);
            }
    }
int amain () //MainL2 ()
    {
        int Z[] = {127, 191, 223, 239, 247, 251, 253, 254};
        ENBL = 0;
        bLEDS = 255;
        while (7)
            {
                char c = ReadKey();
                if (c > '0' && c < '9') dLEDS[int(c - 48 - 1)] = 0; //bLEDS = Z[c - 48 - 1];
                if (c == '0') bLEDS = 0;
                if (c == '*') TrciLijevo();
                if (c == '#') TrciDesno();
                switch (c)
                    {
                        case 'A':
                            bLEDS = 255; //Samo ako efekat traje za vrijeme drzanja tastera
                            dLEDS[0] = dLEDS[1] = 0;
                            break;
                        case 'B':
                            bLEDS = 255; 
                            dLEDS[2] = dLEDS[3] = 0;
                            break;
                        case 'C': 
                            bLEDS = 255; 
                            dLEDS[4] = dLEDS[5] = 0;
                            break;
                        case 'D':
                            bLEDS = 255; 
                            dLEDS[6] = dLEDS[7] = 0;
                            break; 
                       
                    }
                wait (0.25);
                bLEDS = 255; // ako je efekat ukljucen samo za vrijeme drzanja tastera
                
            }
    }
