#include "mbed.h"
#include "sMotor.h"
 
 
Serial pc(USBTX, USBRX);
sMotor motor(dp9, dp10, dp11, dp13); // creates new stepper motor: IN1, IN2, IN3, IN4
 
int step_speed = 1200 ; // set default motor speed
int numstep = 512 ; // defines full turn of 360 degree
int direction = 0; //0 for right, 1 for left
bool upaljen = false;
char c; 
 
void meni()
{
    pc.printf("Default Speed: %d, press: \n\r",step_speed);
    pc.printf("1- postavljanje u proizvoljan polozaj\n\r");
    pc.printf("2- promjena smjera kretanja motora\n\r");
    pc.printf("3- promjena brzine\n\r");
    pc.printf("4- pokretanje/zaustavljanje motora\n\r");
}
 
void postaviOsovinu(){
    int ugao;
    pc.printf("\n Unesi ugao: \n\r");
    pc.scanf("%d", &ugao);
    if (ugao > 0 )
        motor.step(numstep / 360 * (ugao % 360), direction, step_speed); // number of steps, direction, speed
    else
        motor.step(numstep / 360 * (ugao % 360), 1 - direction, step_speed); // number of steps, direction, speed
    meni();if(upaljen) motor.step(numstep, direction, step_speed);
}

void promijeniSmjer(){
    direction = 1 - direction;
    pc.printf("\n Smjer je promjenjen\n");
    meni();if(upaljen) motor.step(numstep, direction, step_speed);
}

void promijeniBrzinu(){
    pc.printf("\n trenutna brzina: %d\n\r", step_speed);
    pc.printf("\n Unesi novu brzinu: \n\r");
    pc.scanf("%d",&step_speed);
    if(upaljen) motor.step(numstep, direction, step_speed);
    meni();if(upaljen) motor.step(numstep, direction, step_speed);
    }
    
void pokreniZaustavi(){
            if(upaljen == false) {
                upaljen = true;
                motor.step(numstep, direction, step_speed);
                pc.printf("\n motor je upaljen \n");
            } else {
                upaljen = false;
                motor.step(numstep, direction, 0);
                pc.printf("\n motor je ugasen \n");
            }
            meni();if(upaljen) motor.step(numstep, direction, step_speed);
    }
    
    
int main()
{
    meni();
    while (1) {
        if (pc.readable()) { // checks for serial
            
            c=pc.getc();
            if (c == '1') {
                /*if(!upaljen) {
                    pc.printf("\n Motor je ugasen, upali motor \n");
                    meni();
                    continue;
                }*/
                postaviOsovinu();
            }
 
            if (c =='2') {
                promijeniSmjer();
            }
            if ( c =='3') {
                promijeniBrzinu();
            }
 
            if (c =='4') {
                pokreniZaustavi();
            }
        }
    }
}

