#include "mbed.h"
#include "N5110.h"

//Deklaracija LCD objekta
//N5110 lcd(VCC,SCE,RST,D/C,MOSI,SCLK,LED)
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);

//Digitalni izlaz za deaktivaciju LED buffera
DigitalOut enable(dp14);

AnalogIn    VRy(dp10);
Ticker pomjeriPlocu;
Ticker loptaTiker;

int loptax, loptay;
int lijeviy = 1, desniy;
int ugao = 45;

void IscrtajOkvir()
{
    for(int i = 0; i < 84; i++) {
        for(int j = 0; j < 48; j++) {
            if(i == 0 || i == 83 || j == 0 || j== 47) {
                lcd.setPixel(i,j);
                lcd.setXYAddress(0,0);
                lcd.refresh();
            }
        }
    }
}

void obrisiBlok(int strana, int pozicija)
{
    if(strana == 0) {
        for(int i = 0; i < 8; i++) {
            lcd.clearPixel(1,pozicija + i);
            lcd.clearPixel(2,pozicija + i);
            lcd.setXYAddress(0,0);
            lcd.refresh();
        }
    } else {
        for(int i = 0; i < 8; i++) {
            lcd.clearPixel(81,pozicija + i + 1);
            lcd.clearPixel(82,pozicija + i + 1);
            lcd.setXYAddress(0,0);
            lcd.refresh();
        }
    }

}

void iscrtajBlok(int strana, int pozicija)
{
    if(strana == 0) {
        for(int i = 0; i < 8; i++) {
            lcd.setPixel(1,pozicija + i);
            lcd.setPixel(2,pozicija + i);
            lcd.setXYAddress(0,0);
            lcd.refresh();
        }
    } else {
        for(int i = 0; i < 8; i++) {
            lcd.setPixel(81,pozicija + i + 1);
            lcd.setPixel(82,pozicija + i + 1);
            lcd.setXYAddress(0,0);
            lcd.refresh();
        }
    }


}

void iscrtajLopticu(int x, int y)
{
    lcd.setXYAddress(0,0);

    for(int i = 0; i < 3; i++) {
        for(int j = 0; j < 3; j++) {
            lcd.setPixel(x+i, y+j);
        }
    }
    lcd.refresh();
}

void obrisiLopticu(int x, int y)
{
    lcd.setXYAddress(0,0);

    for(int i = 0; i < 3; i++) {
        for(int j = 0; j < 3; j++) {
            lcd.clearPixel(x+i, y+j);
        }
    }
    lcd.refresh();
}


void pomjerajBlok()
{
    obrisiBlok(0, lijeviy);
    if(VRy < 0.4 && lijeviy > 1) {
        lijeviy -= 1;
    } else if(VRy > 0.6 && lijeviy < 39)
        lijeviy += 1;
    iscrtajBlok(0, lijeviy);
}

void pomjerajLopticu()
{
    obrisiLopticu(loptax, loptay);
    if(ugao == 0) {
        if(loptax != 1 && loptax != 82 && loptay != 1 && loptay != 46) {
            if(ugao == 0)
                loptax += 2;
            else if(ugao == 30) {
                loptax += 2;
                loptay -= 1;
            } else if(ugao == 45) {
                loptax += 2;
                loptay -= 2;
            } else if(ugao == 60) {
                loptax += 1;
                loptay -= 2;
            } else if(ugao == 120) {
                loptax -= 1;
                loptay -= 2;
            } else if(ugao == 150) {
                loptax -= 2;
                loptay -= 1;
            } else if(ugao == 180) {
                loptax -= 2;
            } else if(ugao == 135) {
                loptax -= 2;
                loptay -= 2;
            }

            else if(ugao == -30) {
                loptax += 2;
                loptay += 1;
            } else if(ugao == -45) {
                loptax += 2;
                loptay += 2;
            } else if(ugao == -60) {
                loptax += 1;
                loptay += 2;
            } else if(ugao == -120) {
                loptax -= 1;
                loptay += 2;
            } else if(ugao == -150) {
                loptax -= 2;
                loptay += 1;
            } else if(ugao == -135) {
                loptax -= 2;
                loptay += 2;
            }
        } else {


        }

    }



}

int main()
{
    enable=1;
    pomjeriPlocu.attach(&pomjerajBlok, 0.07);
    loptaTiker.attach(&pomjerajLopticu, 0.07);
    // inicijalizacija displeja
    lcd.init();
    IscrtajOkvir();

    iscrtajBlok(1, 10);

    while(1);
}

