#include "mbed.h"
#include "N5110.h"
 
Serial pc (USBTX, USBRX); 
//Deklaracija LCD objekta
//N5110 lcd(VCC,SCE,RST,D/C,MOSI,SCLK,LED)
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);

  int x(0), y(0);
  
void deleteAll()
{
    lcd.clear();
    lcd.refresh();
    x = y = 0;
}
  
void deleteLetter()
{
     if(x == 0 && y == 0)
    {   
        x = 84;
        y = 47;
        return;
    }
    
    if(x == 0)
    {
        y = y - 1;
        x = 84;
        return;
    }
    
    for(int i = x - 1; i >= x - 6; i--)
    {
        lcd.clearPixel(i,y);
    }
    
    lcd.refresh();
    x = x - 6;
}

void newLine()
{
    if(y == 47) y = 0;
    else y = y + 1;
    
    x = 0;
}

void getChar()
{
    if(pc.readable())
    {
    char c = pc.getc();
   // if (c == backspace)
    deleteLetter();
   // else if (c == del)
    deleteAll();
   // else if (c == enter)
    newLine();
   // else
    {
    lcd.printChar(c);
       
    x += 6;
    
    if(x == 84 && y != 5)
    { 
        x = 0;
        y++;
    }
    }
    lcd.setXYAddress(x,y);
    }
}

int main() {
    // initialise display 
  lcd.init();
  lcd.normalMode();
  
  lcd.setXYAddress(0,0);
  pc.attach(&getChar);
  while(1);
    
}
