#include "mbed.h"
 #include "TSISensor.h"
 
Serial pc(USBTX, USBRX); // tx, rx
PwmOut ledR(LED1), ledG(LED2), ledB(LED3);
TSISensor tsi;
Ticker ticker;
 
float brightness = 1.0;

void printTSI()
{
    pc.printf("Percentage of tsi is %f\n", tsi.readPercentage());
}
 
 int getBrightness()
 {
     char c1 = pc.getc();
     char c2 = pc.getc();
     if( c1 < '0' || c2 < '0' || c1 > '9' || c2 > '9' ) return -1;
     else return (c1 - '0') * 10 + c2 - '0';
 }
 void getCommand()
 {
     char c = pc.getc();
     brightness = getBrightness();
     if(brightness == -1) return;
     switch(c) 
     {
        case 'R':
            ledG = ledB = 1.0;
            ledR = brightness / 100.0;
            break;
        case 'G':
            ledR = ledB = 1.0;
            ledG = brightness / 100.0;
            break;
        case 'B':
            ledG = ledR = 1.0;
            ledB = brightness / 100.0;
            break;
        case 'P':
            ticker.attach(&printTSI, 1);
            break;
        case 'Z':
           ticker.detach();
           break;
        default:
        return;
    }
    }
    
int main() {
    pc.printf("Press XDD -> X to turn R/G/B diode up and DD to adjust its brightness,or P to start measuring TSI and Z to stop it\n");
    ledR = ledG = ledB = 1.0;
    pc.attach(&getCommand);
    while(1) {
    
    }
}