#include "mbed.h"
//                  0     1     2     3     4     5     6     7     8     9     a     b     c     d     e     *     #
char lookup[17] = { 0x40, 0x79, 0x24, 0x30, 0x19, 0x12, 0x02, 0x78, 0x00, 0x10, 0x20, 0x03, 0x46, 0x21, 0x04, 0x09, 0x01};
DigitalOut displays[3] = { dp25, dp24, dp23 };
DigitalOut dec_p = dp4; 
AnalogIn ain(dp9);
 
// Mapiranja su:
// A - dp26 (bit 0)
// B - dp27 (bit 1)
// C - dp5 (bit 2)
// D - dp6 (bit 3)
// E - dp28 (bit 4)
// F - dp1 (bit 5)
// G - dp2 (bit 6)
 
BusOut segments (dp26, dp27, dp5, dp6, dp28, dp1, dp2);
/*
* Funkcija treba pisati na segment displaya, argumenti su:
* index - kaze na koji display treba pisati (moguce vrijednosti su 2 do 4)
* value - vrijednost koja se treba zapisati (moguce vrijednosti su cifre od 0 do 9)
* decimal_point - vrijednost koja kaze da li treba decimalnu tacku osvijetliti (moguce vrijednosti su
0 ili 1; 0 - iskljuceno, 1 - ukljuceno)
*/
void write_segment(int index, int value, int decimal_point)
{ 
 if(value >= 0 && value <= 9)
// Preslikavanje vrijednosti broja u kod
segments = lookup[value];
 
else 
segments = 0xff;
 
// DP je spojen na dp4
dec_p = !(decimal_point & (1 << 0));
 
// Aktiviramo odgovarajuci display
// D2 je spojen na dp23
// D3 je spojen na dp24
// D4 je spojen na dp25
switch (index)
{
case 2:
displays[0] = 0;
displays[1] = 1;
displays[2] = 1;
break;
case 3:
displays[0]= 1;
displays[1] = 0;
displays[2]  = 1;
break;
case 4:
displays[2]  = 1;
displays[2]  = 1;
displays[2]  = 0;
break;
}
}

int main()
{
// Varijabla koja ce reci koji display je trenutno aktivan (ima vrijednosti od 2 do 4)
int index = 2;

float Vmin(0.27), Vmax(1.72);

float value, old_value(3.3 * ain), value_proc;

// Vrijednosti na pojedinim displayjima:
int d2 = 'N', d3 = 'N', d4 = 'N';
 
while (true)
{
// Pisanje cifara na display
switch (index)
{
case 2:
write_segment(index, d2, 0);
break;

case 3:
write_segment(index, d3, 0);
break;
case 4:
write_segment(index, d4, 0);
break;
}
// 1 ms cekanje
// Ako je pauza izmedju pojedinih pisanja 1ms to znaci da je za 3 displaya potrebno 3ms
// Sto ispadne 1s / 3ms = 333.33 osvjezavanja u sekundi
wait(0.001);
 
value = 3.3 * ain;
 
if (value != old_value )
{ 
value_proc = (Vmax - value)/(Vmax - Vmin) * 100.00;

d4 = value_proc / 100;

 if(d4 == 0)
d4 = 'N';

d3 =(int) (value_proc / 10) % 10;
 if( d3 == 0 )
 d3 = 'N';
 
d2 = (int) value_proc % 10;
}
 
old_value = value;
// Prelazimo na iduci display
index++;
if (index == 5)
index = 2;
}
return 0;
}
     