#include "mbed.h"
#include "N5110.h"
 
//Analogni ulazi sa dzojstika
AnalogIn    VRx(dp11);
AnalogIn    VRy(dp10);
//Taster sa dzojstika
DigitalIn   SW(dp9);

//Deklaracija LCD objekta
//N5110 lcd(VCC,SCE,RST,D/C,MOSI,SCLK,LED)
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);


//Digitalni izlaz za deaktivaciju LED buffera
DigitalOut enable(dp14);

//koordinate crosshair kursora / na sredini ekrana
int x1(40), y1(23), x2(41), y2(22), x3(42), y3(23), x4(41), y4(24);
 
//koordinate tacaka dijagonala 
int xd1(-1), yd1(-1), xd2(-1), yd2(-1);

//taster za dodavanje tacke/ brisanje svih tacaka
InterruptIn taster1(dp1);

// timer koji mjeri vrijeme izmedju dva tastera
Timer timer; 

//funkcija za pravljenje pravougaonika kad vec imamo tacke dijagonale
void makeRectangle()
{
    taster1.disable_irq();
    int Ax, Ay, Bx, By, Cx, Cy, Dx, Dy;
    if( xd1  < xd2 && yd1 > yd2 )
    {
        Bx = xd2;
        By = yd2;
        Dx = xd1;
        Dy = yd1;
        
        Ax = Dx;
        Ay = By;
        Cx = Bx;
        Cy = Dy;
    }
    else if(  xd2  < xd1 && yd2 > yd1 ) 
    {
        Bx = xd1;
        By = yd1;
        Dx = xd2;
        Dy = yd2;
    
        Ax = Dx;
        Ay = By;
        Cx = Bx;
        Cy = Dy;    
    }
    else if ( xd1 < xd2 && yd1 < yd2 )
    {
        Ax = xd1;
        Ay = yd1;
        Cx = xd2;
        Cy = yd2;
        
        Bx = Cx;
        By = Ay;
        Dx = Ax;
        Dy = Cy;
    }
    else if ( xd2 < xd1 && yd2 < yd1 )
    {
        Ax = xd2;
        Ay = yd2;
        Cx = xd1;
        Cy = yd1;
        
        
        Bx = Cx;
        By = Ay;
        Dx = Ax;
        Dy = Cy; 
    }
    
    int i, j;
    // crtamo pravougaonik
    for( i = Ay; i <= Dy; i++)
    for( j = Ax; j <= Cx; j++)
    {
        lcd.setPixel(j,i);
        lcd.refresh();
    }
    taster1.enable_irq();
}

// funkcija za dodavanje tacke dijagonale/ pravljenje pravougaonika

void setPoint()
{
 if( timer.read() < 0.001) return;
 if(timer.read() <= 0.01)
 {
     lcd.clear();
     xd1 = -1;
     yd1 = -1;
     xd2 = -1;
     yd2 = -1;
     x1 = 40;
     y1 = 23; 
     x2 = 41;
     y2 = 22;
     x3 = 42;
     y3 = 23;
     x4 = 41;
     y4 = 24;
     lcd.setPixel(x1,y1);
     lcd.setPixel(x2,y2);
     lcd.setPixel(x3,y3);
     lcd.setPixel(x4,y4);
     lcd.refresh();
     timer.reset();
     return;
 }  
 if( xd1 < 0 )
 {
     xd1 = x2;
     yd1 = y1;
     lcd.setPixel(xd1, yd1);
     lcd.refresh();
 }
 else 
 {
     if( xd2 != xd1 && yd2 != yd1)
     {
     xd2 = x2;
     yd2 = y1;
     makeRectangle();
     xd1 = -1;
     yd1 = -1;
     xd2 = -1;
     yd2 = -1;
     }
 }
  timer.reset();
 }
 
int main()
{
    timer.start();
    taster1.rise(&setPoint);
     enable=1;
 
    // inicijalizacija displaya
    lcd.init();
 
    while(1) {
        if (VRx < 1.0/3.0 && x1 > 0 ) 
        {
            lcd.clearPixel(x1,y1);
            lcd.clearPixel(x2,y2);
            lcd.clearPixel(x3,y3);
            lcd.clearPixel(x4,y4);
            lcd.refresh();
            
            x1--;
            x2--;
            x3--;
            x4--;
            
            lcd.setPixel(x1,y1);
            lcd.setPixel(x2,y2);
            lcd.setPixel(x3,y3);
            lcd.setPixel(x4,y4);
            lcd.refresh();
            
        }
        else if (VRx > 2.0/3.0 && x3 < 47)
        {
            lcd.clearPixel(x1,y1);
            lcd.clearPixel(x2,y2);
            lcd.clearPixel(x3,y3);
            lcd.clearPixel(x4,y4);
            lcd.refresh();
            
            x1++;
            x2++;
            x3++;
            x4++;
            
            lcd.setPixel(x1,y1);
            lcd.setPixel(x2,y2);
            lcd.setPixel(x3,y3);
            lcd.setPixel(x4,y4);
            lcd.refresh();            
        }
 
        if ( VRy < 1.0/3.0 && y2 > 0) 
         {
            lcd.clearPixel(x1,y1);
            lcd.clearPixel(x2,y2);
            lcd.clearPixel(x3,y3);
            lcd.clearPixel(x4,y4);
            lcd.refresh();
            
            y1--;
            y2--;
            y3--;
            y4--;
            
            lcd.setPixel(x1,y1);
            lcd.setPixel(x2,y2);
            lcd.setPixel(x3,y3);
            lcd.setPixel(x4,y4);
            lcd.refresh();            
        }
        else if (VRy > 2.0/3.0 && y4 < 83) 
         {
            lcd.clearPixel(x1,y1);
            lcd.clearPixel(x2,y2);
            lcd.clearPixel(x3,y3);
            lcd.clearPixel(x4,y4);
            lcd.refresh();
            
            y1++;
            y2++;
            y3++;
            y4++;
            
            lcd.setPixel(x1,y1);
            lcd.setPixel(x2,y2);
            lcd.setPixel(x3,y3);
            lcd.setPixel(x4,y4);
            lcd.refresh();
            
        }
 
        wait(0.01);
 
     }
}